/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class GateInDependenciesDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final ModuleDependency GATEIN_LIB;
    private static final ModuleDependency GATEIN_WCI;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (GateInConfiguration.isGateInArchiveOrSubDeployment(du) || GateInConfiguration.isPortletArchive(du)) {
            ModuleSpecification moduleSpec = (ModuleSpecification)du.getAttachment(Attachments.MODULE_SPECIFICATION);
            moduleSpec.addSystemDependency(GATEIN_LIB);
            moduleSpec.addSystemDependency(GATEIN_WCI);
            ModuleIdentifier moduleId = (ModuleIdentifier)du.getAttachment(Attachments.MODULE_IDENTIFIER);
            if (GateInConfiguration.isGateInArchive(du)) {
                GateInConfiguration config = (GateInConfiguration)du.getAttachment(GateInConfigurationKey.KEY);
                ServiceModuleLoader deploymentModuleLoader = (ServiceModuleLoader)du.getAttachment(Attachments.SERVICE_MODULE_LOADER);
                if (!moduleId.equals(config.getGateInEarModule())) {
                    moduleSpec.addSystemDependency(new ModuleDependency((ModuleLoader)deploymentModuleLoader, config.getGateInEarModule(), false, false, false, false));
                }
                for (ModuleIdentifier id : config.getGateInExtModules()) {
                    if (moduleId.equals(id)) continue;
                    moduleSpec.addSystemDependency(new ModuleDependency((ModuleLoader)deploymentModuleLoader, id, false, false, false, false));
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    static {
        ModuleLoader loader = Module.getBootModuleLoader();
        GATEIN_LIB = new ModuleDependency(loader, ModuleIdentifier.fromString((String)"org.gatein.lib"), false, false, true, false);
        GATEIN_WCI = new ModuleDependency(loader, ModuleIdentifier.fromString((String)"org.gatein.wci"), false, false, true, false);
    }
}

