/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portlet.responsive.community;

import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.net.URL;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portlet.responsive.community.RomeRssControllerBean;
import org.gatein.portlet.responsive.community.RssReaderBean;

public class CommunityPortlet
extends GenericPortlet {
    private String DEFAULT_URL = "/#";
    private String URL_RSS_BLOG = "url.rss.blog";
    private String URL_RSS_VIMEO = "url.rss.vimeo";
    private String URL_CONTENT_BLOG = "url.blog";
    private String URL_CONTENT_VIMEO = "url.vimeo";
    private String PFX_BLOG_AUTHOR = "pfx.url.author";
    private static final Logger log = LoggerFactory.getLogger(CommunityPortlet.class);

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher("/jsp/community.jsp");
        prd.include(request, response);
    }

    private RssReaderBean makeReaderBean(String urlRss, String urlContent, int head, String pfxBlogAuthor) {
        RssReaderBean rssReaderBean = new RssReaderBean();
        rssReaderBean.setSourceIO(urlRss);
        try {
            URL rssSourceUrl = new URL(urlRss);
            rssReaderBean.setFeedTitles(RomeRssControllerBean.getFeedTitles((URL)rssSourceUrl, (int)head));
            rssReaderBean.setContentSource(new URL(urlContent));
            rssReaderBean.setAuthorUrlPrefix(pfxBlogAuthor);
        }
        catch (IOException e) {
            rssReaderBean.setValid(false);
            log.debug((Object)("Unable to open RSS feed url: " + e));
        }
        catch (FeedException e) {
            rssReaderBean.setValid(false);
            log.debug((Object)("Problem with RSS feed: " + (Object)((Object)e)));
        }
        return rssReaderBean;
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletPreferences portletPreferences = request.getPreferences();
        String contentType = request.getParameter("type");
        if ("blog".equals(contentType)) {
            String urlRssBlog = portletPreferences.getValue(this.URL_RSS_BLOG, this.DEFAULT_URL);
            String urlContentBlog = portletPreferences.getValue(this.URL_CONTENT_BLOG, this.DEFAULT_URL);
            String pfxBlogAuthor = portletPreferences.getValue(this.PFX_BLOG_AUTHOR, "");
            RssReaderBean gateInBlogRssReader = this.makeReaderBean(urlRssBlog, urlContentBlog, 2, pfxBlogAuthor);
            request.setAttribute("blogRSSBean", (Object)gateInBlogRssReader);
            PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher("/jsp/feedBlog.jsp");
            prd.include((PortletRequest)request, (PortletResponse)response);
        } else if ("vimeo".equals(contentType)) {
            String urlRssVimeo = portletPreferences.getValue(this.URL_RSS_VIMEO, this.DEFAULT_URL);
            String urlContentVimeo = portletPreferences.getValue(this.URL_CONTENT_VIMEO, this.DEFAULT_URL);
            RssReaderBean gateInVimeoRssReader = this.makeReaderBean(urlRssVimeo, urlContentVimeo, 2, null);
            request.setAttribute("vimeoRSSBean", (Object)gateInVimeoRssReader);
            PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher("/jsp/feedVimeo.jsp");
            prd.include((PortletRequest)request, (PortletResponse)response);
        }
    }
}

