/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityTokenCodec;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobCrypterSecurityTokenCodecTest {
    private BlobCrypterSecurityTokenCodec codec;
    private final FakeTimeSource timeSource = new FakeTimeSource();

    @Before
    public void setUp() throws Exception {
        AbstractContainerConfig config = new AbstractContainerConfig(){

            public Object getProperty(String container, String name) {
                if ("gadgets.securityTokenKeyFile".equals(name)) {
                    return BlobCrypterSecurityTokenCodecTest.this.getContainerKey(container);
                }
                if ("gadgets.signedFetchDomain".equals(name)) {
                    return container + ".com";
                }
                throw new RuntimeException("Mock not smart enough, unknown name " + name);
            }

            public Collection<String> getContainers() {
                return Lists.newArrayList((Object[])new String[]{"container", "example"});
            }
        };
        this.codec = new CodecWithLoadStubbedOut((ContainerConfig)config);
    }

    protected String getContainerKey(String container) {
        return "KEY FOR CONTAINER " + container;
    }

    protected BlobCrypter getBlobCrypter(String fileName) {
        BasicBlobCrypter c = new BasicBlobCrypter(CharsetUtil.getUtf8Bytes((String)fileName));
        c.timeSource = this.timeSource;
        return c;
    }

    @Test
    public void testCreateToken() throws Exception {
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(this.getBlobCrypter(this.getContainerKey("container")), "container", null);
        t.setAppUrl("http://www.example.com/gadget.xml");
        t.setModuleId(12345L);
        t.setOwnerId("owner");
        t.setViewerId("viewer");
        t.setTrustedJson("trusted");
        String encrypted = t.encrypt();
        SecurityToken t2 = this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
        Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppId());
        Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppUrl());
        Assert.assertEquals((Object)"container.com", (Object)t2.getDomain());
        Assert.assertEquals((long)12345L, (long)t2.getModuleId());
        Assert.assertEquals((Object)"owner", (Object)t2.getOwnerId());
        Assert.assertEquals((Object)"viewer", (Object)t2.getViewerId());
        Assert.assertEquals((Object)"trusted", (Object)t2.getTrustedJson());
    }

    @Test
    public void testUnknownContainer() throws Exception {
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(this.getBlobCrypter(this.getContainerKey("container")), "container", null);
        t.setAppUrl("http://www.example.com/gadget.xml");
        t.setModuleId(12345L);
        t.setOwnerId("owner");
        t.setViewerId("viewer");
        t.setTrustedJson("trusted");
        String encrypted = t.encrypt();
        encrypted = encrypted.replace("container:", "other:");
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"should have reported that container was unknown");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Unknown container"));
        }
    }

    @Test
    public void testWrongContainer() throws Exception {
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(this.getBlobCrypter(this.getContainerKey("container")), "container", null);
        t.setAppUrl("http://www.example.com/gadget.xml");
        t.setModuleId(12345L);
        t.setOwnerId("owner");
        t.setViewerId("viewer");
        t.setTrustedJson("trusted");
        String encrypted = t.encrypt();
        encrypted = encrypted.replace("container:", "example:");
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"should have tried to decrypt with wrong key");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid token signature"));
        }
    }

    @Test
    public void testExpired() throws Exception {
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(this.getBlobCrypter(this.getContainerKey("container")), "container", null);
        t.setAppUrl("http://www.example.com/gadget.xml");
        t.setModuleId(12345L);
        t.setOwnerId("owner");
        t.setViewerId("viewer");
        t.setTrustedJson("trusted");
        String encrypted = t.encrypt();
        this.timeSource.incrementSeconds(3781);
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"should have expired");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Blob expired"));
        }
    }

    @Test
    public void testMalformed() throws Exception {
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)"foo"));
            Assert.fail((String)"should have tried to decrypt with wrong key");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid security token foo"));
        }
    }

    @Test
    public void testAnonymous() throws Exception {
        SecurityToken t = this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)"   "));
        Assert.assertTrue((boolean)t.isAnonymous());
        ImmutableMap empty = ImmutableMap.of();
        t = this.codec.createToken((Map)empty);
        Assert.assertTrue((boolean)t.isAnonymous());
    }

    @Test
    public void testLoadFailure() throws Exception {
        AbstractContainerConfig config = new AbstractContainerConfig(){

            public Object getProperty(String container, String name) {
                if ("gadgets.securityTokenKeyFile".equals(name)) {
                    return BlobCrypterSecurityTokenCodecTest.this.getContainerKey(container);
                }
                if ("gadgets.signedFetchDomain".equals(name)) {
                    return container + ".com";
                }
                throw new RuntimeException("Mock not smart enough, unknown name " + name);
            }

            public Collection<String> getContainers() {
                return Lists.newArrayList((Object[])new String[]{"container", "example", "failure"});
            }
        };
        try {
            new CodecWithLoadStubbedOut((ContainerConfig)config);
            Assert.fail((String)"Should have failed to load crypter");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Load failed"));
        }
    }

    private class CodecWithLoadStubbedOut
    extends BlobCrypterSecurityTokenCodec {
        public CodecWithLoadStubbedOut(ContainerConfig config) {
            super(config);
        }

        protected BlobCrypter loadCrypterFromFile(File file) throws IOException {
            if (file.getPath().contains("fail")) {
                throw new IOException("Load failed: " + file);
            }
            return BlobCrypterSecurityTokenCodecTest.this.getBlobCrypter(file.getPath());
        }
    }
}

