/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.uri;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class UriTest {
    @Test
    public void parseFull() {
        Uri uri = Uri.parse((String)"http://apache.org/foo?a=b&a=c&b=d+e#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
        Assert.assertEquals((Object)"http://apache.org/foo?a=b&a=c&b=d+e#blah", (Object)uri.toString());
    }

    @Test
    public void parseNoScheme() {
        Uri uri = Uri.parse((String)"//apache.org/foo?a=b&a=c&b=d+e#blah");
        Assert.assertNull((Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoAuthority() {
        Uri uri = Uri.parse((String)"http:/foo?a=b&a=c&b=d+e#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertNull((Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoPath() {
        Uri uri = Uri.parse((String)"http://apache.org?a=b&a=c&b=d+e#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        List<String> params = Arrays.asList("b", "c");
        Assert.assertEquals(params, (Object)uri.getQueryParameters("a"));
        Assert.assertEquals((Object)"b", (Object)uri.getQueryParameter("a"));
        Assert.assertEquals((Object)"d e", (Object)uri.getQueryParameter("b"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoQuery() {
        Uri uri = Uri.parse((String)"http://apache.org/foo#blah");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertNull((Object)uri.getQuery());
        Assert.assertEquals((long)0L, (long)uri.getQueryParameters().size());
        Assert.assertNull((Object)uri.getQueryParameter("foo"));
        Assert.assertEquals((Object)"blah", (Object)uri.getFragment());
    }

    @Test
    public void parseNoFragment() {
        Uri uri = Uri.parse((String)"http://apache.org/foo?a=b&a=c&b=d+e");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)uri.getPath());
        Assert.assertEquals((Object)"a=b&a=c&b=d+e", (Object)uri.getQuery());
        Assert.assertNull((Object)uri.getFragment());
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseInvalidHost() {
        Uri.parse((String)"http://A&E%#%#%/foo?a=b#blah");
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseInvalidScheme() {
        Uri.parse((String)"----://apache.org/foo?a=b#blah");
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseInvalidPath() {
        Uri.parse((String)"http://apache.org/foo\\---(&%?a=b#blah");
    }

    @Test
    public void toJavaUri() {
        URI javaUri = URI.create("http://example.org/foo/bar/baz?blah=blah#boo");
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Assert.assertEquals((Object)javaUri, (Object)uri.toJavaUri());
    }

    @Test
    public void toJavaUriWithSpecialChars() {
        URI javaUri = URI.create("http://example.org/foo/bar/baz?blah=bl%25ah#boo");
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=bl%25ah#boo");
        Assert.assertEquals((Object)javaUri, (Object)uri.toJavaUri());
    }

    @Test
    public void fromJavaUri() throws Exception {
        URI javaUri = URI.create("http://example.org/foo/bar/baz?blah=blah#boo");
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Assert.assertEquals((Object)uri, (Object)Uri.fromJavaUri((URI)javaUri));
    }

    @Test
    public void resolveFragment() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"#bar");
        Assert.assertEquals((Object)"http://example.org/foo/bar/baz?blah=blah#bar", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolveQuery() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"?hello=world");
        Assert.assertEquals((Object)"http://example.org/foo/bar/?hello=world", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathIncludesSubdirs() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"fez/../huey/./dewey/../louis");
        Assert.assertEquals((Object)"http://example.org/foo/bar/huey/louis", (Object)base.resolve(other).toString());
    }

    @Ignore
    public void resolvePathSubdirsExtendsBeyondRoot() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"../random/../../../../../home");
        Assert.assertEquals((Object)"http://example.org/home", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathRelative() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"wee");
        Assert.assertEquals((Object)"http://example.org/foo/bar/wee", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathRelativeToNullPath() throws Exception {
        Uri base = new UriBuilder().setScheme("http").setAuthority("example.org").toUri();
        Uri other = Uri.parse((String)"dir");
        Assert.assertEquals((Object)"http://example.org/dir", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolvePathAbsolute() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"/blah");
        Assert.assertEquals((Object)"http://example.org/blah", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolveAuthority() throws Exception {
        Uri base = Uri.parse((String)"https://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"//example.com/blah");
        Assert.assertEquals((Object)"https://example.com/blah", (Object)base.resolve(other).toString());
    }

    @Test
    public void resolveAbsolute() throws Exception {
        Uri base = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri other = Uri.parse((String)"http://www.ietf.org/rfc/rfc2396.txt");
        Assert.assertEquals((Object)"http://www.ietf.org/rfc/rfc2396.txt", (Object)base.resolve(other).toString());
    }

    @Test
    public void absoluteUrlIsAbsolute() {
        Assert.assertTrue((String)"Url with scheme not reported absolute.", (boolean)Uri.parse((String)"http://example.org/foo").isAbsolute());
    }

    @Test
    public void relativeUrlIsNotAbsolute() {
        Assert.assertFalse((String)"Url without scheme reported absolute.", (boolean)Uri.parse((String)"//example.org/foo").isAbsolute());
    }

    @Test
    public void parseWithSpecialCharacters() {
        String original = "http://example.org/?foo%25pbar=baz+blah";
        Assert.assertEquals((Object)original, (Object)Uri.parse((String)original).toString());
    }

    @Test
    public void equalsAndHashCodeOk() {
        Uri uri = Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Uri uri2 = new UriBuilder().setScheme("http").setAuthority("example.org").setPath("/foo/bar/baz").addQueryParameter("blah", "blah").setFragment("boo").toUri();
        Assert.assertEquals((Object)uri, (Object)uri2);
        Assert.assertEquals((Object)uri2, (Object)uri);
        Assert.assertEquals((long)uri.hashCode(), (long)uri2.hashCode());
    }
}

