/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import org.apache.commons.codec.binary.Base64;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.Functions;
import org.apache.shindig.expressions.OpensocialFunctions;
import org.apache.shindig.expressions.RootELResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpensocialFunctionsTest
extends Assert {
    private Expressions expressions;
    private ELContext context;
    private Map<String, Object> vars = Maps.newHashMap();

    @Before
    public void setUp() {
        Functions functions = new Functions(new Class[]{OpensocialFunctions.class});
        this.expressions = Expressions.forTesting((Functions)functions);
        this.context = this.expressions.newELContext(new ELResolver[]{new RootELResolver(this.vars)});
    }

    @Test
    public void testParseJsonObject() {
        ValueExpression testParseJsonObject = this.expressions.parse("${osx:parseJson('{a: 1}').a}", Integer.class);
        OpensocialFunctionsTest.assertEquals((Object)1, (Object)testParseJsonObject.getValue(this.context));
    }

    @Test
    public void testParseJsonArray() {
        ValueExpression testParseJsonArray = this.expressions.parse("${osx:parseJson('[1, 2, 3]')[1]}", Integer.class);
        OpensocialFunctionsTest.assertEquals((Object)2, (Object)testParseJsonArray.getValue(this.context));
    }

    @Test
    public void testDecodeBase64() throws Exception {
        String test = "12345";
        String encoded = new String(Base64.encodeBase64((byte[])test.getBytes("UTF-8")), "UTF-8");
        this.vars.put("encoded", encoded);
        ValueExpression testDecodeBase64 = this.expressions.parse("${osx:decodeBase64(encoded)}", String.class);
        OpensocialFunctionsTest.assertEquals((Object)"12345", (Object)testDecodeBase64.getValue(this.context));
    }

    @Test
    public void testUrlEncode() throws Exception {
        String test = "He He";
        this.vars.put("test", test);
        ValueExpression testUrlEncode = this.expressions.parse("${osx:urlEncode(test)}", String.class);
        OpensocialFunctionsTest.assertEquals((Object)"He+He", (Object)testUrlEncode.getValue(this.context));
    }

    @Test
    public void testUrlDecode() throws Exception {
        String test = "He+He";
        this.vars.put("encoded", test);
        ValueExpression testUrlDecode = this.expressions.parse("${osx:urlDecode(encoded)}", String.class);
        OpensocialFunctionsTest.assertEquals((Object)"He He", (Object)testUrlDecode.getValue(this.context));
    }

    @Test
    public void testParseJsonNull() throws Exception {
        ValueExpression testUrlEncode = this.expressions.parse("${osx:parseJson(null)}", String.class);
        OpensocialFunctionsTest.assertEquals((Object)"", (Object)testUrlEncode.getValue(this.context));
    }

    @Test
    public void testDecodeBase64Null() throws Exception {
        ValueExpression testUrlEncode = this.expressions.parse("${osx:decodeBase64(null)}", String.class);
        OpensocialFunctionsTest.assertEquals((Object)"", (Object)testUrlEncode.getValue(this.context));
    }

    @Test
    public void testUrlEncodeNull() throws Exception {
        ValueExpression testUrlEncode = this.expressions.parse("${osx:urlEncode(null)}", String.class);
        OpensocialFunctionsTest.assertEquals((Object)"", (Object)testUrlEncode.getValue(this.context));
    }

    @Test
    public void testUrlDecodeNull() throws Exception {
        ValueExpression testUrlDecode = this.expressions.parse("${osx:urlDecode(null)}", String.class);
        OpensocialFunctionsTest.assertEquals((Object)"", (Object)testUrlDecode.getValue(this.context));
    }
}

