/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.shindig.protocol.conversion.BeanDelegator;
import org.apache.shindig.protocol.conversion.BeanFilter;
import org.junit.Before;
import org.junit.Test;

public class BeanDelegatorTest
extends Assert {
    private BeanDelegator beanDelegator;
    private SimpleBean source;
    private SimpleBeanInterface proxy;

    public static BeanDelegator createSimpleDelegator() {
        BeanDelegator beanDelegator = new BeanDelegator((Map)ImmutableMap.of(SimpleBean.class, SimpleBeanInterface.class, SimpleBean.RealStyle.class, SimpleBeanInterface.Style.class), (Map)ImmutableMap.of((Object)((Object)SimpleBean.RealStyle.R_A), (Object)((Object)SimpleBeanInterface.Style.A), (Object)((Object)SimpleBean.RealStyle.R_B), (Object)((Object)SimpleBeanInterface.Style.B)));
        return beanDelegator;
    }

    @Before
    public void setUp() {
        this.beanDelegator = BeanDelegatorTest.createSimpleDelegator();
        this.source = new SimpleBean();
        this.proxy = (SimpleBeanInterface)this.beanDelegator.createDelegator((Object)this.source);
    }

    @Test
    public void testSimpleBean() {
        String s = "test";
        this.source.setS(s);
        BeanDelegatorTest.assertEquals((String)s, (String)this.proxy.getS());
        this.proxy.setI(5);
        BeanDelegatorTest.assertEquals((int)5, (int)this.proxy.getI());
        BeanDelegatorTest.assertEquals((int)5, (int)this.source.getI());
        this.source.setStyle(SimpleBean.RealStyle.R_A);
        BeanDelegatorTest.assertEquals((Object)((Object)SimpleBeanInterface.Style.A), (Object)((Object)this.proxy.getStyle()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnimplementedFunction() {
        this.proxy.getUnknown();
    }

    @Test(expected=ClassCastException.class)
    public void testWrontType() {
        this.proxy.getWrongType();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPrivateAccess() {
        this.proxy.getPrivateData();
    }

    @Test
    public void testStringList() {
        BeanDelegatorTest.assertNull(this.proxy.getList());
        ImmutableList stringList = ImmutableList.of((Object)"item1", (Object)"item2");
        this.source.setList((List<String>)stringList);
        BeanDelegatorTest.assertEquals((Object)stringList, this.proxy.getList());
        stringList = ImmutableList.of();
        this.source.setList((List<String>)stringList);
        BeanDelegatorTest.assertEquals((Object)stringList, this.proxy.getList());
    }

    @Test
    public void testBeanList() {
        ImmutableList beanList = ImmutableList.of();
        this.source.setBeanList((List<SimpleBean>)beanList);
        BeanDelegatorTest.assertEquals((Object)beanList, this.proxy.getBeanList());
        SimpleBean item = new SimpleBean().setS("item");
        beanList = ImmutableList.of((Object)item);
        this.source.setBeanList((List<SimpleBean>)beanList);
        List<SimpleBeanInterface> interList = this.proxy.getBeanList();
        BeanDelegatorTest.assertEquals((int)1, (int)interList.size());
        BeanDelegatorTest.assertEquals((String)item.getS(), (String)interList.get(0).getS());
    }

    @Test
    public void testStringMap() {
        BeanDelegatorTest.assertNull(this.proxy.getMap());
        ImmutableMap stringMap = ImmutableMap.of((Object)"item1", (Object)"v1", (Object)"item2", (Object)"v2");
        this.source.setMap((Map<String, String>)stringMap);
        BeanDelegatorTest.assertEquals((Object)stringMap, this.proxy.getMap());
        stringMap = ImmutableMap.of();
        this.source.setMap((Map<String, String>)stringMap);
        BeanDelegatorTest.assertEquals((Object)stringMap, this.proxy.getMap());
    }

    @Test
    public void testBeanMap() {
        ImmutableMap beanMap = ImmutableMap.of();
        this.source.setBeanMap((Map<String, SimpleBean>)beanMap);
        BeanDelegatorTest.assertEquals((Object)beanMap, this.proxy.getBeanMap());
        SimpleBean item = new SimpleBean().setS("item");
        beanMap = ImmutableMap.of((Object)"item", (Object)item);
        this.source.setBeanMap((Map<String, SimpleBean>)beanMap);
        Map<String, SimpleBeanInterface> interMap = this.proxy.getBeanMap();
        BeanDelegatorTest.assertEquals((int)1, (int)interMap.size());
        BeanDelegatorTest.assertEquals((String)item.getS(), (String)interMap.get("item").getS());
    }

    @Test
    public void testExtraFields() {
        TokenData data = new TokenData();
        String container = "data";
        TokenInter p = (TokenInter)this.beanDelegator.createDelegator((Object)data, TokenInter.class, (Map)ImmutableMap.of((Object)"container", (Object)container));
        BeanDelegatorTest.assertSame((Object)data.getId(), (Object)p.getId());
        BeanDelegatorTest.assertSame((Object)container, (Object)p.getContainer());
    }

    @Test(expected=NoSuchMethodException.class)
    public void tesValidate() throws Exception {
        this.beanDelegator.validate();
    }

    static interface TokenInter {
        public String getId();

        public String getContainer();
    }

    class TokenData {
        TokenData() {
        }

        public String getId() {
            return "id";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleBean {
        private int i;
        private String s;
        private List<String> l;
        private List<SimpleBean> beanList;
        private Map<String, String> stringMap;
        private Map<String, SimpleBean> beanMap;
        RealStyle style;

        public int getI() {
            return this.i;
        }

        public SimpleBean setI(int ni) {
            this.i = ni;
            return this;
        }

        public String getS() {
            return this.s;
        }

        public SimpleBean setS(String ns) {
            this.s = ns;
            return this;
        }

        public List<String> getList() {
            return this.l;
        }

        public SimpleBean setList(List<String> nl) {
            this.l = nl;
            return this;
        }

        public List<SimpleBean> getBeanList() {
            return this.beanList;
        }

        public SimpleBean setBeanList(List<SimpleBean> nl) {
            this.beanList = nl;
            return this;
        }

        public Map<String, String> getMap() {
            return this.stringMap;
        }

        public SimpleBean setMap(Map<String, String> nm) {
            this.stringMap = nm;
            return this;
        }

        public Map<String, SimpleBean> getBeanMap() {
            return this.beanMap;
        }

        public SimpleBean setBeanMap(Map<String, SimpleBean> nm) {
            this.beanMap = nm;
            return this;
        }

        public String getWrongType() {
            return "this is string";
        }

        private String getPrivateData() {
            return "this is private";
        }

        public RealStyle getStyle() {
            return this.style;
        }

        public SimpleBean setStyle(RealStyle style) {
            this.style = style;
            return this;
        }

        public String getRequired() {
            return "required";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RealStyle {
            R_A,
            R_B;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SimpleBeanInterface {
        public int getI();

        public SimpleBeanInterface setI(int var1);

        public String getS();

        public List<String> getList();

        public List<SimpleBeanInterface> getBeanList();

        public Map<String, String> getMap();

        public Map<String, SimpleBeanInterface> getBeanMap();

        public String getUnknown();

        public int getWrongType();

        public String getPrivateData();

        public Style getStyle();

        @BeanFilter.Unfiltered
        public String getRequired();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Style {
            A,
            B;

        }
    }
}

