/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="activities", path="/{userId}+/{groupId}/{appId}/{activityId}+")
public class ActivityHandler {
    private final ActivityService service;
    private final ContainerConfig config;

    @Inject
    public ActivityHandler(ActivityService service, ContainerConfig config) {
        this.service = service;
        this.config = config;
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet activityIds = ImmutableSet.copyOf((Collection)request.getListParameter("activityId"));
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        return this.service.deleteActivities((UserId)Iterables.getOnlyElement(userIds), request.getGroup(), request.getAppId(), (Set<String>)activityIds, request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="activity")
    public Future<?> update(SocialRequestItem request) throws ProtocolException {
        return this.create(request);
    }

    @Operation(httpMethods={"POST"}, bodyParam="activity")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        List activityIds = request.getListParameter("activityId");
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        HandlerPreconditions.requireEmpty((Collection)activityIds, (String)"Cannot specify activityId in create");
        return this.service.createActivity((UserId)Iterables.getOnlyElement(userIds), request.getGroup(), request.getAppId(), request.getFields(), (Activity)request.getTypedParameter("activity", Activity.class), request.getToken());
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet optionalActivityIds = ImmutableSet.copyOf((Collection)request.getListParameter("activityId"));
        CollectionOptions options = new CollectionOptions((RequestItem)request);
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        if (userIds.size() > 1 && !optionalActivityIds.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch same activityIds for multiple userIds");
        }
        if (!optionalActivityIds.isEmpty()) {
            if (optionalActivityIds.size() == 1) {
                return this.service.getActivity(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), (String)optionalActivityIds.iterator().next(), request.getToken());
            }
            return this.service.getActivities(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), options, (Set<String>)optionalActivityIds, request.getToken());
        }
        return this.service.getActivities(userIds, request.getGroup(), request.getAppId(), request.getFields(), options, request.getToken());
    }

    @Operation(httpMethods={"GET"}, path="/@supportedFields")
    public List<Object> supportedFields(RequestItem request) {
        String container = ActivityHandler.firstNonNull(request.getToken().getContainer(), "default");
        return this.config.getList(container, "${Cur['gadgets.features']['opensocial-0.8'].supportedFields.activity}");
    }

    private static <T> T firstNonNull(T first, T second) {
        return (T)(first != null ? first : Preconditions.checkNotNull(second));
    }
}

