/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.josso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.xml.InitParams;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.GenericAgent;
import org.gatein.sso.agent.josso.GateInJOSSOAgentFactory;
import org.gatein.sso.agent.josso.JOSSOAgent;
import org.gatein.sso.agent.josso.JOSSOUtils;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.HttpSSOAgent;

public class JOSSOAgentImpl
extends GenericAgent
implements JOSSOAgent {
    private static Logger log = LoggerFactory.getLogger(JOSSOAgentImpl.class);
    private HttpSSOAgent httpAgent;

    public JOSSOAgentImpl(InitParams params) {
        try {
            this.httpAgent = JOSSOUtils.lookupSSOAgent();
            this.httpAgent.start();
            log.info((Object)"JOSSO agent started successfuly!");
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void validateTicket(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String ticket = httpRequest.getParameter("josso_assertion_id");
        log.debug((Object)("Trying to validate the following Ticket: " + ticket));
        String requester = JOSSOUtils.getPartnerAppId((AbstractSSOAgent)this.httpAgent, httpRequest);
        SSOAgentRequest agentRequest = this.doMakeSSOAgentRequest(requester, 2, null, ticket, httpRequest, httpResponse);
        SingleSignOnEntry entry = this.httpAgent.processRequest(agentRequest);
        if (entry != null) {
            String sessionId = agentRequest.getSessionId();
            String assertionId = agentRequest.getAssertionId();
            String principal = entry.principal.getName();
            log.debug((Object)("SessionId: " + sessionId));
            log.debug((Object)("AssertionId: " + assertionId));
            log.debug((Object)("Principal: " + principal));
            this.saveSSOCredentials(principal, httpRequest);
        }
    }

    protected SSOAgentRequest doMakeSSOAgentRequest(String requester, int action, String sessionId, String assertionId, HttpServletRequest hreq, HttpServletResponse hres) {
        return GateInJOSSOAgentFactory.getInstance().getSSOAgentRequest(requester, action, sessionId, assertionId, hreq, hres);
    }
}

