/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.tomcat;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.gatein.wci.spi.CatalinaWebAppContext;

public class TC7WebAppContext
extends CatalinaWebAppContext {
    private final Context context;
    private Wrapper commandServlet;

    TC7WebAppContext(Context context) throws Exception {
        super(context.getServletContext(), context.getLoader().getClassLoader(), context.getPath());
        this.context = context;
    }

    protected void performStartup() throws Exception {
        try {
            String className = this.getCommandServletClassName();
            if (null == className) {
                return;
            }
            this.commandServlet = this.context.createWrapper();
            this.commandServlet.setName("TomcatGateInServlet");
            this.commandServlet.setLoadOnStartup(0);
            this.commandServlet.setServletClass(className);
            this.context.addChild((Container)this.commandServlet);
            this.context.addServletMapping("/tomcatgateinservlet", "TomcatGateInServlet");
        }
        catch (Exception e) {
            this.cleanup();
            throw e;
        }
    }

    protected void cleanup() {
        if (this.commandServlet != null) {
            try {
                this.context.removeServletMapping("/tomcatgateinservlet");
                this.context.removeChild((Container)this.commandServlet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public HttpSession getHttpSession(String sessId) {
        Manager mgr = this.context.getManager();
        if (mgr != null) {
            try {
                Session sess = mgr.findSession(sessId);
                if (sess != null) {
                    return sess.getSession();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void fireRequestDestroyed(ServletRequest servletRequest) {
        Object[] instances = this.context.getApplicationEventListeners();
        if (null != instances && instances.length > 0) {
            ServletRequestEvent event = new ServletRequestEvent(this.context.getServletContext(), servletRequest);
            for (int i = instances.length - 1; i >= 0; --i) {
                if (null == instances[i] || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    log.warn((Object)("Error calling requestDestroyed() for " + listener.toString()), t);
                }
            }
        }
    }

    public void fireRequestInitialized(ServletRequest servletRequest) {
        Object[] instances = this.context.getApplicationEventListeners();
        if (null != instances && instances.length > 0) {
            ServletRequestEvent event = new ServletRequestEvent(this.context.getServletContext(), servletRequest);
            for (int i = 0; i < instances.length; ++i) {
                if (null == instances[i] || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    log.warn((Object)("Error calling requestInitialized() for " + listener.toString()), t);
                }
            }
        }
    }
}

