/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

public class ExtendedAssert
extends Assert {
    public static void assertEquals(Object[] expected, Object[] actual) {
        ExtendedAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Object[] expected, Object[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        ExtendedAssert.fail((String)ExtendedAssert.format(message, expected, actual));
    }

    public static void assertEquals(char[] expected, char[] actual) {
        ExtendedAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char[] expected, char[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        ExtendedAssert.fail((String)ExtendedAssert.format(message, expected, actual));
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        ExtendedAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        ExtendedAssert.fail((String)ExtendedAssert.format(message, ExtendedAssert.toString(expected), ExtendedAssert.toString(actual)));
    }

    private static String toString(byte[] expected) {
        StringBuffer expectedBuffer = new StringBuffer("[");
        for (byte expectedByte : expected) {
            expectedBuffer.append(expectedByte).append(',');
        }
        if (expectedBuffer.length() == 1) {
            expectedBuffer.append(']');
        } else {
            expectedBuffer.setCharAt(expectedBuffer.length(), ']');
        }
        return expectedBuffer.toString();
    }

    public static String format(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + ExtendedAssert.format(expected) + "> but was:<" + ExtendedAssert.format(actual) + ">";
    }

    private static String format(Object o) {
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            StringBuffer buffer = new StringBuffer("[");
            for (int i = 0; i < array.length; ++i) {
                buffer.append(i == 0 ? "" : ",").append(String.valueOf(array[i]));
            }
            buffer.append("]");
            return buffer.toString();
        }
        return String.valueOf(o);
    }

    public static void assertEquals(Object[] expected, Object[] tested, boolean isOrderRelevant, String failMessage) {
        if (isOrderRelevant) {
            if (!Arrays.equals(expected, tested)) {
                ExtendedAssert.fail((String)failMessage);
            }
        } else {
            boolean equals;
            boolean bl = equals = expected == tested;
            if (!equals) {
                List<Object> testedList;
                List<Object> expectedList;
                if (expected == null || tested == null) {
                    ExtendedAssert.fail((String)(failMessage + " Not both null."));
                }
                if (expected.getClass().getComponentType() != tested.getClass().getComponentType()) {
                    ExtendedAssert.fail((String)(failMessage + " Different classes."));
                }
                if (expected.length != tested.length) {
                    ExtendedAssert.fail((String)(failMessage + " Different sizes (tested: " + tested.length + ", expected: " + expected.length + ")."));
                }
                if (!(expectedList = Arrays.asList(expected)).containsAll(testedList = Arrays.asList(tested))) {
                    ExtendedAssert.fail((String)failMessage);
                }
            }
        }
    }

    public static void assertEquals(Object[] expected, Object[] tested, boolean isOrderRelevant, String failMessage, Decorator decorator) {
        Object[] decoratedExpected = null;
        Object[] decoratedTested = null;
        if (decorator != null) {
            decoratedExpected = ExtendedAssert.decorate(expected, decorator);
            decoratedTested = ExtendedAssert.decorate(tested, decorator);
        }
        ExtendedAssert.assertEquals(decoratedExpected, decoratedTested, isOrderRelevant, failMessage);
    }

    public static Object[] decorate(Object[] toBeDecorated, Decorator decorator) {
        if (toBeDecorated != null) {
            Object[] decorated = new DecoratedObject[toBeDecorated.length];
            for (int i = 0; i < decorated.length; ++i) {
                decorated[i] = new DecoratedObject(toBeDecorated[i], decorator);
            }
            return decorated;
        }
        return null;
    }

    public static void assertString1ContainsString2(String string1, String string2) {
        ExtendedAssert.assertTrue((String)("<" + string1 + "> does not contain <" + string2 + ">"), (string1.indexOf(string2) >= 0 ? 1 : 0) != 0);
    }

    public static class DecoratedObject {
        private Decorator decorator;
        private Object decorated;

        public Object getDecorated() {
            return this.decorated;
        }

        public DecoratedObject(Object decorated, Decorator decorator) {
            this.decorator = decorator;
            this.decorated = decorated;
        }

        public boolean equals(Object obj) {
            this.decorator.decorate(this.decorated);
            return this.decorator.equals(obj);
        }

        public String toString() {
            this.decorator.decorate(this.decorated);
            return this.decorator.toString();
        }
    }

    public static interface Decorator {
        public void decorate(Object var1);
    }
}

