/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.handler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gatein.wsrp.test.handler.MockSOAPMessage;

public class MockSOAPMessageContext
implements InvocationHandler {
    MockSOAPMessage message;
    Map<String, List<String>> httpHeaders = new HashMap<String, List<String>>();

    public MockSOAPMessageContext(MockSOAPMessage message) {
        this.message = message;
    }

    public MockSOAPMessage getMessage() {
        return this.message;
    }

    public void setMessage(MockSOAPMessage message) {
        this.message = message;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getMessage".equals(methodName)) {
            return this.getMessage();
        }
        if ("get".equals(methodName)) {
            if ("javax.xml.ws.service.endpoint.address".equals(args[0])) {
                return "http://jboss.com";
            }
            if ("javax.xml.ws.http.request.headers".equals(args[0])) {
                return this.httpHeaders;
            }
            throw new IllegalArgumentException("MockSOAPMessageContext.get method should only be called to retrieve javax.xml.ws.service.endpoint.address or javax.xml.ws.http.request.headers values. Requested: " + args[0]);
        }
        if ("put".equals(methodName)) {
            if ("javax.xml.ws.http.request.headers".equals(args[0])) {
                this.httpHeaders = (Map)args[1];
                return null;
            }
            throw new IllegalArgumentException("MockSOAPMessageContext.put method should only be called to add Cookies. Tried to add " + args[0] + " with value " + args[1]);
        }
        if ("toString".equals(methodName)) {
            return this.toString();
        }
        throw new UnsupportedOperationException("MockSOAPMessageContext does not support " + methodName + " method");
    }

    public static SOAPMessageContext createMessageContext(MockSOAPMessage message, ClassLoader classLoader) {
        return (SOAPMessageContext)Proxy.newProxyInstance(classLoader, new Class[]{SOAPMessageContext.class}, (InvocationHandler)new MockSOAPMessageContext(message));
    }
}

