/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.payload;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import org.gatein.wsrp.WSRPConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XSDTypeConverter {
    ANY_SIMPLE_TYPE("anySimpleType"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseAnySimpleType((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printAnySimpleType((String)((String)((Object)value)));
        }

        public Class getJavaType() {
            return Object.class;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_ANY_SIMPLE_TYPE;
        }
    }
    ,
    BASE64_BINARY("base64Binary"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseBase64Binary((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printBase64Binary((byte[])((byte[])value));
        }

        public Class getJavaType() {
            return byte[].class;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_BASE_64_BINARY;
        }
    }
    ,
    BOOLEAN("boolean"){

        public Serializable parseFromXML(String value) {
            return Boolean.valueOf(DatatypeConverter.parseBoolean((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printBoolean((boolean)((Boolean)value));
        }

        public Class getJavaType() {
            return Boolean.TYPE;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_BOOLEAN;
        }
    }
    ,
    BYTE("byte"){

        public Serializable parseFromXML(String value) {
            return Byte.valueOf(DatatypeConverter.parseByte((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printByte((byte)((Byte)value));
        }

        public Class getJavaType() {
            return Byte.TYPE;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_BYTE;
        }
    }
    ,
    DATE("date"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseDate((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printDate((Calendar)((Calendar)value));
        }

        public Class getJavaType() {
            return null;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_DATE;
        }
    }
    ,
    DATE_TIME("dateTime"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseDateTime((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printDateTime((Calendar)((Calendar)value));
        }

        public Class getJavaType() {
            return Calendar.class;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_DATE_TIME;
        }
    }
    ,
    DECIMAL("decimal"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseDecimal((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printDecimal((BigDecimal)((BigDecimal)value));
        }

        public Class getJavaType() {
            return BigDecimal.class;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_DECIMAL;
        }
    }
    ,
    DOUBLE("double"){

        public Serializable parseFromXML(String value) {
            return Double.valueOf(DatatypeConverter.parseDouble((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printDouble((double)((Double)value));
        }

        public Class getJavaType() {
            return Double.TYPE;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_DOUBLE;
        }
    }
    ,
    FLOAT("float"){

        public Serializable parseFromXML(String value) {
            return Float.valueOf(DatatypeConverter.parseFloat((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printFloat((float)((Float)value).floatValue());
        }

        public Class getJavaType() {
            return Float.TYPE;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_FLOAT;
        }
    }
    ,
    HEX_BINARY("hexBinary"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseHexBinary((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printHexBinary((byte[])((byte[])value));
        }

        public Class getJavaType() {
            return null;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_HEX_BINARY;
        }
    }
    ,
    INT("int"){

        public Serializable parseFromXML(String value) {
            return Integer.valueOf(DatatypeConverter.parseInt((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printInt((int)((Integer)value));
        }

        public Class getJavaType() {
            return Integer.TYPE;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_INT;
        }
    }
    ,
    INTEGER("integer"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseInteger((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printInteger((BigInteger)((BigInteger)value));
        }

        public Class getJavaType() {
            return BigInteger.class;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_INTEGER;
        }
    }
    ,
    LONG("long"){

        public Serializable parseFromXML(String value) {
            return Long.valueOf(DatatypeConverter.parseLong((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printLong((long)((Long)value));
        }

        public Class getJavaType() {
            return Long.TYPE;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_LONG;
        }
    }
    ,
    SHORT("short"){

        public Serializable parseFromXML(String value) {
            return Short.valueOf(DatatypeConverter.parseShort((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printShort((short)((Short)value));
        }

        public Class getJavaType() {
            return Short.TYPE;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_SHORT;
        }
    }
    ,
    STRING("string"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseString((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printString((String)((String)((Object)value)));
        }

        public Class getJavaType() {
            return String.class;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_STRING;
        }
    }
    ,
    TIME("time"){

        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseTime((String)value);
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printTime((Calendar)((Calendar)value));
        }

        public Class getJavaType() {
            return null;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_TIME;
        }
    }
    ,
    UNSIGNED_INT("unsignedInt"){

        public Serializable parseFromXML(String value) {
            return Long.valueOf(DatatypeConverter.parseUnsignedInt((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printUnsignedInt((long)((Long)value));
        }

        public Class getJavaType() {
            return null;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_UNSIGNED_INT;
        }
    }
    ,
    UNSIGNED_SHORT("unsignedShort"){

        public Serializable parseFromXML(String value) {
            return Integer.valueOf(DatatypeConverter.parseUnsignedShort((String)value));
        }

        public String printToXML(Serializable value) {
            return DatatypeConverter.printUnsignedShort((int)((Integer)value));
        }

        public Class getJavaType() {
            return null;
        }

        public QName getXSDType() {
            return WSRPConstants.XSD_UNSIGNED_SHORT;
        }
    };

    private String typeName;

    private XSDTypeConverter(String typeName) {
        this.typeName = typeName;
    }

    public String typeName() {
        return this.typeName;
    }

    public abstract Serializable parseFromXML(String var1);

    public abstract String printToXML(Serializable var1);

    public abstract Class getJavaType();

    public abstract QName getXSDType();
}

