/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.rmi.RemoteException;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.wsrp.consumer.RequestPrecursor;
import org.gatein.wsrp.consumer.SessionHandler;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.oasis.wsrp.v1.InvalidCookie;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.InvalidSession;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.UserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InvocationHandler {
    protected WSRPConsumerImpl consumer;
    protected static Logger log = LoggerFactory.getLogger(InvocationHandler.class);
    private static final int DO_NOT_RETRY = -1;
    private static final int MAXIMUM_RETRY_NUMBER = 3;

    public InvocationHandler(WSRPConsumerImpl consumer) {
        this.consumer = consumer;
    }

    PortletInvocationResponse handle(PortletInvocation invocation) throws PortletInvokerException {
        RequestPrecursor requestPrecursor = new RequestPrecursor(this.consumer, invocation);
        Object request = this.prepareRequest(requestPrecursor, invocation);
        Object response = this.performRequest(request, invocation);
        if (response instanceof ErrorResponse) {
            return this.unwrapWSRPError((ErrorResponse)response);
        }
        return this.processResponse(response, invocation, requestPrecursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performRequest(Object request, PortletInvocation invocation) throws PortletInvokerException {
        int retryCount = 0;
        Object response = null;
        while (response == null && retryCount++ <= 3) {
            log.debug("performRequest: " + retryCount + " attempt(s) out of " + 3 + " possible");
            SessionHandler sessionHandler = this.consumer.getSessionHandler();
            this.updateRegistrationContext(request);
            RuntimeContext runtimeContext = this.getRuntimeContextFrom(request);
            WindowContext windowContext = invocation.getWindowContext();
            runtimeContext.setNamespacePrefix(this.getNamespaceFrom(windowContext));
            InstanceContext instanceContext = invocation.getInstanceContext();
            runtimeContext.setPortletInstanceKey(instanceContext == null ? null : instanceContext.getId());
            this.updateUserContext(request, this.consumer.getUserContextFrom(invocation, runtimeContext));
            this.consumer.setTemplatesIfNeeded(invocation, runtimeContext);
            try {
                sessionHandler.initCookieIfNeeded(invocation);
                sessionHandler.initProducerSessionInformation(invocation);
                response = this.performRequest(request);
                sessionHandler.updateCookiesIfNeeded(invocation);
            }
            catch (Exception e) {
                ErrorResponse errorResponse = this.dealWithError(e, invocation, runtimeContext);
                if (errorResponse == null) continue;
                ErrorResponse errorResponse2 = errorResponse;
                return errorResponse2;
            }
            finally {
                sessionHandler.resetCurrentlyHeldInformation();
            }
        }
        if (retryCount >= 3) {
            return new ErrorResponse((Throwable)new RuntimeException("Tried to perform request 3 times before giving up. This usually happens if an error in the WS stack prevented the messages to be properly transmitted. Look at server.log for clues as to what happened..."));
        }
        log.debug("performRequest finished. Response is " + (response != null ? response.getClass().getName() : null));
        return response;
    }

    protected String getNamespaceFrom(WindowContext windowContext) {
        if (windowContext != null) {
            String id = windowContext.getId();
            id = id.replace('=', '_');
            id = id.replace('/', '_');
            id = id.replace('.', '_');
            return id.replace('+', '_');
        }
        return null;
    }

    private ErrorResponse dealWithError(Exception error, PortletInvocation invocation, RuntimeContext runtimeContext) throws PortletInvokerException {
        log.error("The portlet threw an exception", (Throwable)error);
        SessionHandler sessionHandler = this.consumer.getSessionHandler();
        if (error instanceof InvalidCookie) {
            log.debug("Re-initializing cookies after InvalidCookieFault.");
            this.consumer.refreshProducerInfo();
            try {
                sessionHandler.initCookieIfNeeded(invocation);
            }
            catch (Exception e) {
                log.debug("Couldn't init cookie: " + e.getLocalizedMessage());
                return new ErrorResponse((Throwable)e);
            }
        } else if (error instanceof InvalidSession) {
            log.debug("Session invalidated after InvalidSessionFault, will re-send session-stored information.");
            sessionHandler.handleInvalidSessionFault(invocation, runtimeContext);
        } else if (error instanceof InvalidRegistration) {
            log.debug("Invalid registration");
            this.consumer.handleInvalidRegistrationFault();
        } else {
            return new ErrorResponse((Throwable)error);
        }
        return null;
    }

    protected ErrorResponse unwrapWSRPError(ErrorResponse errorResponse) {
        Throwable cause = errorResponse.getCause();
        if (cause != null) {
            if (cause instanceof OperationFailed && cause.getCause() != null) {
                cause = cause.getCause();
            } else if (cause instanceof RemoteException) {
                cause = ((RemoteException)cause).detail;
            }
            log.debug("Invocation of action failed: " + cause.getMessage(), cause);
            return new ErrorResponse(cause);
        }
        log.debug("Invocation of action failed: " + errorResponse.getMessage());
        return errorResponse;
    }

    protected abstract void updateUserContext(Object var1, UserContext var2);

    protected abstract void updateRegistrationContext(Object var1) throws PortletInvokerException;

    protected abstract RuntimeContext getRuntimeContextFrom(Object var1);

    protected abstract Object performRequest(Object var1) throws Exception;

    protected abstract Object prepareRequest(RequestPrecursor var1, PortletInvocation var2);

    protected abstract PortletInvocationResponse processResponse(Object var1, PortletInvocation var2, RequestPrecursor var3) throws PortletInvokerException;
}

