/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RefreshResult;
import org.gatein.wsrp.consumer.RegistrationProperty;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.oasis.wsrp.v1.ModelDescription;
import org.oasis.wsrp.v1.Property;
import org.oasis.wsrp.v1.PropertyDescription;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RegistrationData;
import org.oasis.wsrp.v1.ServiceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationInfo
implements RegistrationProperty.PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(RegistrationInfo.class);
    private Long key;
    private String persistentConsumerName;
    private String persistentRegistrationHandle;
    private byte[] persistentRegistrationState;
    private Map<String, RegistrationProperty> persistentRegistrationProperties;
    private transient Boolean requiresRegistration;
    private transient Boolean consistentWithProducerExpectations;
    private transient RegistrationData registrationData;
    private transient boolean modifiedSinceLastRefresh;
    private transient boolean modifyRegistrationNeeded;
    private transient ProducerInfo parent;
    private static final String UNDETERMINED_REGISTRATION = "__JBP__UNDETERMINED__REGISTRATION__";

    public RegistrationInfo(ProducerInfo producerInfo) {
        this();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)producerInfo, (String)"ProducerInfo");
        producerInfo.setRegistrationInfo(this);
        this.parent = producerInfo;
    }

    static RegistrationInfo createUndeterminedRegistration(ProducerInfo producerInfo) {
        return new RegistrationInfo(producerInfo);
    }

    public boolean isUndetermined() {
        return UNDETERMINED_REGISTRATION.equals(this.persistentConsumerName);
    }

    public RegistrationInfo(ProducerInfo producerInfo, boolean requiresRegistration) {
        this(producerInfo);
        this.requiresRegistration = requiresRegistration;
    }

    RegistrationInfo() {
        this.persistentConsumerName = UNDETERMINED_REGISTRATION;
    }

    public RegistrationInfo(RegistrationInfo other) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)other, (String)"RegistrationInfo to clone from");
        this.persistentConsumerName = other.persistentConsumerName;
        this.persistentRegistrationHandle = other.persistentRegistrationHandle;
        this.parent = other.parent;
        if (other.persistentRegistrationState != null) {
            this.persistentRegistrationState = new byte[other.persistentRegistrationState.length];
            System.arraycopy(other.persistentRegistrationState, 0, this.persistentRegistrationState, 0, other.persistentRegistrationState.length);
        }
        if (other.persistentRegistrationProperties != null) {
            this.persistentRegistrationProperties = new HashMap<String, RegistrationProperty>(other.persistentRegistrationProperties.size());
            for (RegistrationProperty otherProp : other.persistentRegistrationProperties.values()) {
                String name = otherProp.getName();
                RegistrationProperty prop = new RegistrationProperty(name, otherProp.getValue(), otherProp.getLang(), this);
                prop.setStatus(otherProp.getStatus());
                this.persistentRegistrationProperties.put(name, prop);
            }
        }
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public String getRegistrationHandle() {
        return this.persistentRegistrationHandle;
    }

    public void setRegistrationHandle(String registrationHandle) {
        this.persistentRegistrationHandle = registrationHandle;
    }

    public byte[] getRegistrationState() {
        return this.persistentRegistrationState;
    }

    public void setRegistrationState(byte[] registrationState) {
        this.persistentRegistrationState = registrationState;
    }

    public ProducerInfo getParent() {
        return this.parent;
    }

    public void setParent(ProducerInfo parent) {
        this.parent = parent;
    }

    public boolean isRefreshNeeded() {
        boolean result;
        boolean bl = result = this.requiresRegistration == null || this.isModifiedSinceLastRefresh();
        if (result) {
            log.debug("Refresh needed");
        }
        return result;
    }

    public Boolean isRegistrationValid() {
        if (this.consistentWithProducerExpectations == null || this.requiresRegistration == null) {
            return null;
        }
        return this.consistentWithProducerExpectations != false && this.hasRegisteredIfNeeded();
    }

    private boolean hasRegisteredIfNeeded() {
        return this.persistentRegistrationHandle != null && this.isRegistrationDeterminedRequired() || this.isRegistrationDeterminedNotRequired();
    }

    public Boolean isConsistentWithProducerExpectations() {
        return this.consistentWithProducerExpectations;
    }

    public Boolean isRegistrationRequired() {
        return this.requiresRegistration;
    }

    public boolean isRegistrationDeterminedRequired() {
        if (this.requiresRegistration == null) {
            throw new IllegalStateException("Registration status not yet known: call refresh first!");
        }
        return this.requiresRegistration;
    }

    public boolean isRegistrationDeterminedNotRequired() {
        if (this.requiresRegistration == null) {
            throw new IllegalStateException("Registration status not yet known: call refresh first!");
        }
        return this.requiresRegistration == false;
    }

    public boolean hasLocalInfo() {
        return this.persistentRegistrationHandle != null || this.isRegistrationPropertiesEmpty();
    }

    public boolean isRegistrationPropertiesEmpty() {
        return this.persistentRegistrationProperties != null && !this.persistentRegistrationProperties.isEmpty();
    }

    public RegistrationData getRegistrationData() {
        this.registrationData = WSRPTypeFactory.createDefaultRegistrationData();
        this.registrationData.setConsumerName(this.persistentConsumerName);
        ArrayList<Property> properties = new ArrayList<Property>();
        Map<String, RegistrationProperty> regProps = this.getRegistrationProperties(false);
        if (!regProps.isEmpty()) {
            for (RegistrationProperty o : regProps.values()) {
                RegistrationProperty prop = o;
                String value = prop.getValue();
                if (value == null || prop.isDeterminedInvalid()) continue;
                properties.add(WSRPTypeFactory.createProperty((String)prop.getName(), (String)prop.getLang(), (String)prop.getValue()));
            }
            this.registrationData.getRegistrationProperties().addAll(properties);
        }
        return this.registrationData;
    }

    public String getConsumerName() {
        return this.persistentConsumerName;
    }

    public void setConsumerName(String consumerName) {
        this.persistentConsumerName = consumerName;
    }

    public String getConsumerAgent() {
        return WSRPConstants.CONSUMER_AGENT;
    }

    public RegistrationProperty getRegistrationProperty(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"registration property name", (String)"RegistrationInfo.getRegistrationProperty");
        return this.getRegistrationProperties(false).get(name);
    }

    public RegistrationProperty setRegistrationPropertyValue(String name, String value) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"registration property name", (String)"RegistrationInfo.setRegistrationPropertyValue");
        RegistrationProperty prop = this.getOrCreateRegistrationPropertiesMap(true).get(name);
        if (prop != null) {
            prop.setValue(value);
        } else {
            prop = new RegistrationProperty(name, value, WSRPUtils.toString((Locale)Locale.getDefault()), this);
            this.getOrCreateRegistrationPropertiesMap(false).put(name, prop);
            this.setModifiedSinceLastRefresh(true);
            this.modifyRegistrationNeeded = true;
        }
        return prop;
    }

    public void removeRegistrationProperty(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"registration property name", (String)"RegistrationInfo.removeRegistrationProperty");
        Map<String, RegistrationProperty> propertiesMap = this.getOrCreateRegistrationPropertiesMap(false);
        if (propertiesMap == null || propertiesMap.remove(name) == null) {
            throw new IllegalArgumentException("Cannot remove inexistent registration property '" + name + "'");
        }
        this.setModifiedSinceLastRefresh(true);
        this.modifyRegistrationNeeded = true;
    }

    private Map<String, RegistrationProperty> getOrCreateRegistrationPropertiesMap(boolean forceCreate) {
        if (forceCreate && this.persistentRegistrationProperties == null) {
            this.persistentRegistrationProperties = new HashMap<String, RegistrationProperty>();
        }
        return this.persistentRegistrationProperties;
    }

    public Map<String, RegistrationProperty> getRegistrationProperties() {
        return this.getRegistrationProperties(true);
    }

    private Map<String, RegistrationProperty> getRegistrationProperties(boolean immutable) {
        Map<String, RegistrationProperty> properties = this.getOrCreateRegistrationPropertiesMap(false);
        if (properties != null) {
            if (immutable) {
                return Collections.unmodifiableMap(properties);
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    public void setRegistrationProperties(Map registrationProperties) {
        this.persistentRegistrationProperties = registrationProperties;
    }

    public Set getRegistrationPropertyNames() {
        return this.getRegistrationProperties().keySet();
    }

    public RegistrationRefreshResult refresh(ServiceDescription serviceDescription, String producerId, boolean mergeWithLocalInfo, boolean forceRefresh, boolean forceCheckOfExtraProps) {
        log.debug("RegistrationInfo refresh requested");
        if (forceRefresh || this.isRefreshNeeded()) {
            if (this.isUndetermined()) {
                this.setConsumerName(WSRPConstants.DEFAULT_CONSUMER_NAME);
            }
            String msg = "Couldn't get a service description to refresh from!";
            if (serviceDescription == null && this.parent != null) {
                try {
                    serviceDescription = this.parent.getServiceDescription(true);
                }
                catch (PortletInvokerException e) {
                    log.debug(msg, (Throwable)e);
                    serviceDescription = null;
                }
            }
            if (serviceDescription == null) {
                throw new IllegalArgumentException(msg);
            }
            this.persistentRegistrationProperties = this.getOrCreateRegistrationPropertiesMap(true);
            RegistrationRefreshResult result = new RegistrationRefreshResult();
            result.setServiceDescription(serviceDescription);
            if (!mergeWithLocalInfo) {
                result.setRegistrationProperties(new HashMap<String, RegistrationProperty>(this.persistentRegistrationProperties));
            }
            this.setModifiedSinceLastRefresh(false);
            this.modifyRegistrationNeeded = false;
            if (serviceDescription.isRequiresRegistration()) {
                this.requiresRegistration = Boolean.TRUE;
                log.debug("Producer '" + producerId + "' requires registration");
                ModelDescription regPropDescs = serviceDescription.getRegistrationPropertyDescription();
                if (regPropDescs != null) {
                    result.setStatus(RefreshResult.Status.SUCCESS);
                    List propertyDescriptions = regPropDescs.getPropertyDescriptions();
                    if (propertyDescriptions != null && !propertyDescriptions.isEmpty()) {
                        Map<String, RegistrationProperty> descriptionsMap = this.getRegistrationPropertyDescriptionsFromWSRP(propertyDescriptions);
                        Set<String> expectedNames = descriptionsMap.keySet();
                        this.checkForExtraProperties(producerId, result, expectedNames, this.persistentRegistrationProperties, !mergeWithLocalInfo);
                        for (RegistrationProperty prop : descriptionsMap.values()) {
                            String name = prop.getName();
                            RegistrationProperty existing = this.getRegistrationProperty(name);
                            if (existing != null) {
                                existing.setDescription(prop.getDescription());
                                if (!existing.isDeterminedInvalid()) continue;
                                result.setStatus(RefreshResult.Status.FAILURE);
                                continue;
                            }
                            if (mergeWithLocalInfo) {
                                this.persistentRegistrationProperties.put(name, prop);
                            } else {
                                prop.setStatus(RegistrationProperty.Status.MISSING);
                                result.getRegistrationProperties().put(name, prop);
                            }
                            log.debug("Missing value for property '" + name + "'");
                            this.setResultAsFailedOrModifyNeeded(result);
                        }
                    } else {
                        this.handleNoRequiredRegistrationProperties(producerId, result, !mergeWithLocalInfo, forceCheckOfExtraProps);
                    }
                } else {
                    this.handleNoRequiredRegistrationProperties(producerId, result, !mergeWithLocalInfo, forceCheckOfExtraProps);
                }
            } else {
                log.debug("Producer '" + producerId + "' doesn't require registration");
                this.requiresRegistration = Boolean.FALSE;
                result.setStatus(RefreshResult.Status.SUCCESS);
            }
            if (mergeWithLocalInfo) {
                result.setRegistrationProperties(this.persistentRegistrationProperties);
            }
            this.consistentWithProducerExpectations = !result.hasIssues();
            log.debug("Registration configuration is " + (this.consistentWithProducerExpectations != false ? "" : "NOT ") + "valid");
            return result;
        }
        RegistrationRefreshResult result = new RegistrationRefreshResult();
        result.setStatus(RefreshResult.Status.BYPASSED);
        result.setRegistrationProperties(this.persistentRegistrationProperties);
        result.setServiceDescription(serviceDescription);
        return result;
    }

    private void handleNoRequiredRegistrationProperties(String producerId, RegistrationRefreshResult result, boolean keepExtra, boolean forceCheckOfExtraProps) {
        log.debug("The producer didn't require any specific registration properties");
        Map<String, RegistrationProperty> properties = this.getOrCreateRegistrationPropertiesMap(false);
        if (properties != null && !properties.isEmpty()) {
            if (forceCheckOfExtraProps || !this.hasRegisteredIfNeeded()) {
                log.debug("Registration data is available when none is expected by the producer");
                this.checkForExtraProperties(producerId, result, Collections.<String>emptySet(), properties, keepExtra);
            } else {
                log.debug("Consumer is registered: producer most likely did not resend property descriptions");
                result.setStatus(RefreshResult.Status.SUCCESS);
            }
        } else {
            log.debug("Using default registration data for producer '" + producerId + "'");
            this.registrationData = WSRPTypeFactory.createDefaultRegistrationData();
            result.setStatus(RefreshResult.Status.SUCCESS);
        }
    }

    private void checkForExtraProperties(String producerId, RegistrationRefreshResult result, Set<String> expectedNames, Map<String, RegistrationProperty> properties, boolean keepExtra) {
        HashSet<String> unexpected = new HashSet<String>(properties.keySet());
        unexpected.removeAll(expectedNames);
        if (!unexpected.isEmpty()) {
            StringBuffer message = new StringBuffer("Unexpected registration properties:\n");
            int size = unexpected.size();
            int index = 0;
            for (String name : unexpected) {
                message.append("'").append(name).append("'");
                if (keepExtra) {
                    RegistrationProperty prop = properties.get(name);
                    prop.setStatus(RegistrationProperty.Status.INVALID_VALUE);
                    prop = result.getRegistrationProperties().get(name);
                    prop.setStatus(RegistrationProperty.Status.INEXISTENT);
                } else {
                    message.append(" (was removed)");
                    properties.remove(name);
                }
                if (index++ == size - 1) continue;
                message.append(";");
            }
            log.debug(message.toString());
            this.setResultAsFailedOrModifyNeeded(result);
        }
    }

    private void setResultAsFailedOrModifyNeeded(RegistrationRefreshResult result) {
        if (this.persistentRegistrationHandle != null) {
            result.setStatus(RefreshResult.Status.MODIFY_REGISTRATION_REQUIRED);
            this.modifyRegistrationNeeded = true;
        } else {
            result.setStatus(RefreshResult.Status.FAILURE);
        }
    }

    private Map<String, RegistrationProperty> getRegistrationPropertyDescriptionsFromWSRP(List<PropertyDescription> descriptions) {
        if (descriptions != null) {
            HashMap<String, RegistrationProperty> result = new HashMap<String, RegistrationProperty>(descriptions.size());
            for (PropertyDescription description : descriptions) {
                String name = description.getName();
                RegistrationPropertyDescription desc = WSRPUtils.convertToRegistrationPropertyDescription((PropertyDescription)description);
                RegistrationProperty prop = new RegistrationProperty(name, null, WSRPUtils.toString((Locale)desc.getLang()), this);
                prop.setDescription(desc);
                prop.setStatus(RegistrationProperty.Status.MISSING_VALUE);
                result.put(name, prop);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    void resetRegistration() {
        this.persistentRegistrationHandle = null;
        this.persistentRegistrationState = null;
    }

    public void setRegistrationContext(RegistrationContext registrationContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationContext, (String)"RegistrationContext");
        String handle = registrationContext.getRegistrationHandle();
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)handle, (String)"registration handle", (String)"RegistrationContext");
        this.persistentRegistrationHandle = handle;
        this.persistentRegistrationState = registrationContext.getRegistrationState();
        this.setRegistrationValidInternalState();
    }

    public void setRegistrationValidInternalState() {
        this.getRegistrationData();
        if (this.persistentRegistrationProperties != null) {
            Iterator<RegistrationProperty> i$ = this.persistentRegistrationProperties.values().iterator();
            while (i$.hasNext()) {
                RegistrationProperty o;
                RegistrationProperty prop = o = i$.next();
                prop.setStatus(RegistrationProperty.Status.VALID);
            }
        }
        this.consistentWithProducerExpectations = Boolean.TRUE;
        this.requiresRegistration = Boolean.TRUE;
        this.setModifiedSinceLastRefresh(false);
        this.modifyRegistrationNeeded = false;
    }

    public RegistrationContext getRegistrationContext() {
        if (this.persistentRegistrationHandle != null) {
            RegistrationContext registrationContext = WSRPTypeFactory.createRegistrationContext((String)this.persistentRegistrationHandle);
            registrationContext.setRegistrationState(this.persistentRegistrationState);
            return registrationContext;
        }
        return null;
    }

    public boolean isModifyRegistrationNeeded() {
        return this.modifyRegistrationNeeded || this.isModifiedSinceLastRefresh();
    }

    public boolean isModifiedSinceLastRefresh() {
        return this.modifiedSinceLastRefresh;
    }

    public void setModifiedSinceLastRefresh(boolean modifiedSinceLastRefresh) {
        this.modifiedSinceLastRefresh = modifiedSinceLastRefresh;
    }

    @Override
    public void propertyValueChanged(RegistrationProperty property, Object oldValue, Object newValue) {
        this.setModifiedSinceLastRefresh(true);
        this.modifyRegistrationNeeded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RegistrationRefreshResult
    extends RefreshResult {
        private Map<String, RegistrationProperty> registrationProperties;

        public Map<String, RegistrationProperty> getRegistrationProperties() {
            return this.registrationProperties;
        }

        public void setRegistrationProperties(Map<String, RegistrationProperty> registrationProperties) {
            this.registrationProperties = registrationProperties;
        }
    }
}

