/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.hibernate;

import java.util.Iterator;
import javax.naming.InitialContext;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.registry.AbstractConsumerRegistry;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateConsumerRegistry
extends AbstractConsumerRegistry {
    private SessionFactory sessionFactory;
    private String sessionFactoryJNDIName;

    @Override
    protected void save(ProducerInfo info, String messageOnError) {
        try {
            Session session = this.sessionFactory.getCurrentSession();
            session.persist((Object)info);
        }
        catch (HibernateException e) {
            throw new ConsumerException(messageOnError, e);
        }
    }

    @Override
    protected void delete(ProducerInfo info) {
        Session session = this.sessionFactory.getCurrentSession();
        session.delete((Object)info);
    }

    public String getSessionFactoryJNDIName() {
        return this.sessionFactoryJNDIName;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    @Override
    protected String update(ProducerInfo producerInfo) {
        String oldId;
        Session session = this.sessionFactory.getCurrentSession();
        try {
            oldId = (String)session.createQuery("select pi.persistentId from ProducerInfo pi where pi.id = :key").setParameter("key", (Object)producerInfo.getKey()).uniqueResult();
            if (producerInfo.getId().equals(oldId)) {
                oldId = null;
            }
            session.update((Object)producerInfo);
        }
        catch (HibernateException e) {
            throw new ConsumerException("Couldn't update ProducerInfo for Consumer '" + producerInfo.getId() + "'", e);
        }
        return oldId;
    }

    @Override
    protected Iterator<ProducerInfo> getProducerInfosFromStorage() {
        Session session = this.sessionFactory.getCurrentSession();
        return session.createQuery("from ProducerInfo pi order by pi.persistentId").iterate();
    }

    @Override
    public void start() throws Exception {
        InitialContext initialContext = new InitialContext();
        this.sessionFactory = (SessionFactory)initialContext.lookup(this.sessionFactoryJNDIName);
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.sessionFactory = null;
        super.stop();
    }
}

