/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.InvocationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.ActionHandler;
import org.gatein.wsrp.consumer.handlers.DirectResourceServingHandler;
import org.gatein.wsrp.consumer.handlers.EventHandler;
import org.gatein.wsrp.consumer.handlers.RenderHandler;
import org.gatein.wsrp.consumer.handlers.ResourceHandler;

public class InvocationDispatcher {
    private final ActionHandler actionHandler;
    private final RenderHandler renderHandler;
    private final ResourceHandler resourceHandler;
    private final EventHandler eventHandler;
    private final WSRPConsumerImpl consumer;
    private final DirectResourceServingHandler directResourceHandler;

    public InvocationDispatcher(WSRPConsumerImpl consumer) {
        this.consumer = consumer;
        this.actionHandler = new ActionHandler(consumer);
        this.renderHandler = new RenderHandler(consumer);
        this.resourceHandler = new ResourceHandler(consumer);
        this.eventHandler = new EventHandler(consumer);
        this.directResourceHandler = new DirectResourceServingHandler(consumer);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public PortletInvocationResponse dispatchAndHandle(PortletInvocation invocation) throws PortletInvokerException {
        boolean preferOperation;
        String preferOperationAsString;
        String resourceURL;
        String resourceId;
        void var2_8;
        if (invocation instanceof RenderInvocation) {
            RenderHandler renderHandler = this.renderHandler;
            return var2_8.handle(invocation);
        }
        if (invocation instanceof ActionInvocation) {
            ActionHandler actionHandler = this.actionHandler;
            return var2_8.handle(invocation);
        }
        if (!(invocation instanceof ResourceInvocation)) {
            if (!(invocation instanceof EventInvocation)) throw new InvocationException("Unknown invocation type: " + invocation);
            EventHandler eventHandler = this.eventHandler;
            return var2_8.handle(invocation);
        }
        ResourceInvocation resourceInvocation = (ResourceInvocation)invocation;
        String resourceInvocationId = resourceInvocation.getResourceId();
        if (!ParameterValidation.isNullOrEmpty((String)resourceInvocationId)) {
            Map resourceMap = WSRPResourceURL.decodeResource((String)resourceInvocationId);
            resourceId = (String)resourceMap.get("wsrp-resourceID");
            resourceURL = (String)resourceMap.get("wsrp-url");
            preferOperationAsString = (String)resourceMap.get("wsrp-preferOperation");
            resourceInvocation.setAttribute("wsrp-url", (Object)resourceURL);
            resourceInvocation.setAttribute("wsrp-resourceID", (Object)resourceId);
            resourceInvocation.setAttribute("wsrp-preferOperation", (Object)preferOperationAsString);
        } else {
            resourceId = null;
            resourceURL = (String)resourceInvocation.getAttribute("wsrp-url");
            preferOperationAsString = (String)resourceInvocation.getAttribute("wsrp-preferOperation");
        }
        boolean bl = preferOperation = preferOperationAsString != null && Boolean.parseBoolean(preferOperationAsString);
        if (this.consumer.isUsingWSRP2() && (preferOperation || resourceURL == null || resourceId != null && resourceId.length() > 0)) {
            ResourceHandler resourceHandler = this.resourceHandler;
            return var2_8.handle(invocation);
        }
        if (resourceURL != null) {
            DirectResourceServingHandler directResourceServingHandler = this.directResourceHandler;
            return var2_8.handle(invocation);
        }
        if (!this.consumer.isUsingWSRP2()) return new ErrorResponse("Did not get a resource URL, cannot fetch resource.");
        return new ErrorResponse("Did not get a resource URL or a resource ID, cannot fetch resource.");
    }
}

