/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.SortedMap;
import org.gatein.common.xml.NullEntityResolver;
import org.gatein.wsrp.consumer.registry.InMemoryConsumerRegistry;
import org.gatein.wsrp.consumer.registry.xml.XMLWSRPConsumerFactory;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class XMLConsumerRegistry
extends InMemoryConsumerRegistry {
    private static final Logger log = LoggerFactory.getLogger(XMLConsumerRegistry.class);
    private static final String defaultWSRPLocation = "conf/wsrp-consumers-config.xml";
    private InputStream configurationIS;
    private EntityResolver entityResolver;

    public XMLConsumerRegistry(InputStream configurationInputStream) {
        this.configurationIS = configurationInputStream;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public void reloadConsumers() {
        if (this.configurationIS == null) {
            URL defaultWSRPURL = Thread.currentThread().getContextClassLoader().getResource(defaultWSRPLocation);
            try {
                this.configurationIS = defaultWSRPURL.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't open default XML WSRP Consumer configuration file", e);
            }
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        XMLWSRPConsumerFactory factory = new XMLWSRPConsumerFactory(this);
        if (this.entityResolver == null) {
            log.debug("Could not obtain entity resolver for XMLConsumerRegistry");
            this.entityResolver = new NullEntityResolver();
        }
        try {
            unmarshaller.setEntityResolver(this.entityResolver);
            this.initConsumers((SortedMap)unmarshaller.unmarshal(this.configurationIS, (ObjectModelFactory)factory, null));
        }
        catch (JBossXBException e) {
            throw new RuntimeException("Couldn't unmarshall WSRP Consumers configuration", e);
        }
    }
}

