/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.portlet.info;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.ParameterInfo;

public class WSRPNavigationInfo
implements NavigationInfo {
    private final Map<String, ParameterInfo> byId;
    private final Map<QName, ParameterInfo> byName;

    public WSRPNavigationInfo(Collection<ParameterInfo> params) {
        if (ParameterValidation.existsAndIsNotEmpty(params)) {
            this.byId = new HashMap<String, ParameterInfo>(params.size());
            this.byName = new HashMap<QName, ParameterInfo>(params.size());
            for (ParameterInfo param : params) {
                this.byId.put(param.getId(), param);
                this.byName.put(param.getName(), param);
            }
        } else {
            this.byId = Collections.emptyMap();
            this.byName = Collections.emptyMap();
        }
    }

    public ParameterInfo getPublicParameter(String id) {
        return this.byId.get(id);
    }

    public ParameterInfo getPublicParameter(QName name) {
        return this.byName.get(name);
    }

    public Collection<? extends ParameterInfo> getPublicParameters() {
        return Collections.unmodifiableCollection(this.byId.values());
    }
}

