/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.cxf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.feature.AbstractFeature;
import org.gatein.wsrp.cxf.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureIntegratorFactory {
    private static Logger log = LoggerFactory.getLogger(FeatureIntegratorFactory.class);
    protected static final FeatureIntegratorFactory instance = new FeatureIntegratorFactory();
    protected List<AbstractFeature> features = new ArrayList<AbstractFeature>();
    public static final String DEFAULT_CXF_FEATURES_CONFIG_FILE_NAME = "producer.features";

    public FeatureIntegratorFactory() {
        try {
            String wsrpCXFConfDir = Utils.getWSRPCXFConfigDirectory();
            File featuresPropertyFile = new File(wsrpCXFConfDir + File.separator + DEFAULT_CXF_FEATURES_CONFIG_FILE_NAME);
            if (featuresPropertyFile.exists()) {
                FileInputStream fileInStream = new FileInputStream(featuresPropertyFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fileInStream));
                String featureClassName = reader.readLine();
                while (featureClassName != null) {
                    AbstractFeature feature;
                    if (!featureClassName.trim().startsWith("#") && !featureClassName.trim().startsWith("!") && (feature = this.createFeature(featureClassName)) != null) {
                        this.features.add(feature);
                    }
                    featureClassName = reader.readLine();
                }
                reader.close();
            } else {
                log.debug("The wsrp cxf features configuration file does not exist [" + featuresPropertyFile + "]. No features will be added to the wsrp producer service classes.");
            }
        }
        catch (Exception e) {
            log.error("Error processing GateIn CXF Feature configuration files", (Throwable)e);
        }
    }

    public static FeatureIntegratorFactory getInstance() {
        return instance;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    protected AbstractFeature createFeature(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (object instanceof AbstractFeature) {
                return (AbstractFeature)object;
            }
            log.error("Class " + className + " listed in feature file is not of type AbstractFeature. This entry is ignored.");
        }
        catch (Exception e) {
            log.error("Error try to create class " + className + " listed in the the feature file. This entry will be ignored.", (Throwable)e);
        }
        return null;
    }
}

