/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.mapping;

import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.registry.mapping.EndpointInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.RegistrationInfoMapping;
import org.gatein.wsrp.jcr.mapping.BaseMapping;

@PrimaryType(name="wsrp:producerinfo")
public abstract class ProducerInfoMapping
implements BaseMapping<ProducerInfo> {
    public static final String NODE_NAME = "wsrp:producerinfo";

    @OneToOne
    @Owner
    @MappedBy(value="endpoint")
    public abstract EndpointInfoMapping getEndpointInfo();

    @OneToOne
    @Owner
    @MappedBy(value="registration")
    public abstract RegistrationInfoMapping getRegistrationInfo();

    @Property(name="producerid")
    public abstract String getId();

    public abstract void setId(String var1);

    @Property(name="cache")
    public abstract Integer getExpirationCacheSeconds();

    public abstract void setExpirationCacheSeconds(Integer var1);

    @Property(name="active")
    @DefaultValue(value={"false"})
    public abstract boolean getActive();

    public abstract void setActive(boolean var1);

    @Id
    public abstract String getKey();

    @Override
    public void initFrom(ProducerInfo producerInfo) {
        this.setActive(producerInfo.isActive());
        this.setExpirationCacheSeconds(producerInfo.getExpirationCacheSeconds());
        this.setId(producerInfo.getId());
        EndpointInfoMapping eim = this.getEndpointInfo();
        eim.initFrom(producerInfo.getEndpointConfigurationInfo());
        RegistrationInfoMapping rim = this.getRegistrationInfo();
        RegistrationInfo regInfo = producerInfo.getRegistrationInfo();
        rim.initFrom(regInfo);
    }

    @Override
    public ProducerInfo toModel(ProducerInfo initial) {
        ProducerInfo info = new ProducerInfo();
        info.setKey(this.getKey());
        info.setId(this.getId());
        info.setActive(this.getActive());
        info.setExpirationCacheSeconds(this.getExpirationCacheSeconds());
        EndpointConfigurationInfo endInfo = this.getEndpointInfo().toEndpointConfigurationInfo(info.getEndpointConfigurationInfo());
        info.setEndpointConfigurationInfo(endInfo);
        RegistrationInfo regInfo = this.getRegistrationInfo().toRegistrationInfo(info.getRegistrationInfo());
        info.setRegistrationInfo(regInfo);
        return info;
    }
}

