/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.chromattic.api.ChromatticSession;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.registry.AbstractConsumerRegistry;
import org.gatein.wsrp.consumer.registry.mapping.EndpointInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.ProducerInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.ProducerInfosMapping;
import org.gatein.wsrp.consumer.registry.mapping.RegistrationInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.RegistrationPropertyMapping;
import org.gatein.wsrp.consumer.registry.xml.XMLConsumerRegistry;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.jcr.StoresByPathManager;
import org.gatein.wsrp.registration.mapping.RegistrationPropertyDescriptionMapping;

public class JCRConsumerRegistry
extends AbstractConsumerRegistry
implements StoresByPathManager<ProducerInfo> {
    private ChromatticPersister persister;
    private boolean loadFromXMLIfNeeded;
    private static final String PRODUCER_INFOS_PATH = "wsrp:producerinfos";
    public static final List<Class> mappingClasses = new ArrayList<Class>(6);

    public JCRConsumerRegistry(ChromatticPersister persister) throws Exception {
        this(persister, true);
    }

    protected JCRConsumerRegistry(ChromatticPersister persister, boolean loadFromXMLIfNeeded) {
        this.persister = persister;
        this.loadFromXMLIfNeeded = loadFromXMLIfNeeded;
    }

    protected void save(ProducerInfo info, String messageOnError) {
        try {
            ChromatticSession session = this.persister.getSession();
            ProducerInfosMapping pims = this.getProducerInfosMapping(session);
            ProducerInfoMapping pim = pims.createProducerInfo(info.getId());
            String key = session.persist((Object)pims, (Object)pim, info.getId());
            info.setKey(key);
            pim.initFrom(info);
            this.persister.closeSession(true);
        }
        catch (Exception e) {
            this.persister.closeSession(false);
            throw new ConsumerException(messageOnError, (Throwable)e);
        }
    }

    protected void delete(ProducerInfo info) {
        if (!this.persister.delete(info, this)) {
            throw new ConsumerException("Couldn't delete ProducerInfo " + info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String update(ProducerInfo producerInfo) {
        boolean idUnchanged;
        String oldId;
        String key = producerInfo.getKey();
        if (key == null) {
            throw new IllegalArgumentException("ProducerInfo '" + producerInfo.getId() + "' hasn't been persisted and thus cannot be updated.");
        }
        ChromatticSession session = this.persister.getSession();
        JCRConsumerRegistry jCRConsumerRegistry = this;
        synchronized (jCRConsumerRegistry) {
            ProducerInfoMapping pim = (ProducerInfoMapping)session.findById(ProducerInfoMapping.class, key);
            if (pim == null) {
                throw new IllegalArgumentException("Couldn't find ProducerInfoMapping associated with key " + key);
            }
            oldId = pim.getId();
            String newId = producerInfo.getId();
            pim.initFrom(producerInfo);
            idUnchanged = oldId.equals(newId);
            if (!idUnchanged) {
                ProducerInfosMapping pims = this.getProducerInfosMapping(session);
                Map<String, ProducerInfoMapping> nameToProducerInfoMap = pims.getNameToProducerInfoMap();
                nameToProducerInfoMap.put(pim.getId(), pim);
            }
            this.persister.closeSession(true);
        }
        return idUnchanged ? null : oldId;
    }

    protected Iterator<ProducerInfo> getProducerInfosFromStorage() {
        ChromatticSession session = this.persister.getSession();
        ProducerInfosMapping producerInfosMapping = this.getProducerInfosMapping(session);
        List<ProducerInfoMapping> mappings = producerInfosMapping.getProducerInfos();
        this.persister.closeSession(true);
        return new MappingToProducerInfoIterator(mappings.iterator());
    }

    private ProducerInfosMapping getProducerInfosMapping(ChromatticSession session) {
        ProducerInfosMapping producerInfosMapping = (ProducerInfosMapping)session.findByPath(ProducerInfosMapping.class, PRODUCER_INFOS_PATH);
        if (producerInfosMapping == null) {
            producerInfosMapping = (ProducerInfosMapping)session.insert(ProducerInfosMapping.class, PRODUCER_INFOS_PATH);
            if (this.loadFromXMLIfNeeded) {
                XMLConsumerRegistry fromXML = new XMLConsumerRegistry();
                fromXML.reloadConsumers();
                List<ProducerInfoMapping> infos = producerInfosMapping.getProducerInfos();
                List consumers = fromXML.getConfiguredConsumers();
                for (WSRPConsumer consumer : consumers) {
                    ProducerInfo info = consumer.getProducerInfo();
                    ProducerInfoMapping pim = producerInfosMapping.createProducerInfo(info.getId());
                    infos.add(pim);
                    pim.initFrom(info);
                }
            }
        }
        return producerInfosMapping;
    }

    @Override
    public String getChildPath(ProducerInfo needsComputedPath) {
        return JCRConsumerRegistry.getPathFor(needsComputedPath);
    }

    private static String getPathFor(ProducerInfo info) {
        return "wsrp:producerinfos/" + info.getId();
    }

    private static ProducerInfoMapping toProducerInfoMapping(ProducerInfo producerInfo, ChromatticSession session) {
        ProducerInfoMapping pim = (ProducerInfoMapping)session.findById(ProducerInfoMapping.class, producerInfo.getKey());
        if (pim == null) {
            pim = (ProducerInfoMapping)session.insert(ProducerInfoMapping.class, JCRConsumerRegistry.getPathFor(producerInfo));
        }
        pim.initFrom(producerInfo);
        return pim;
    }

    static {
        Collections.addAll(mappingClasses, ProducerInfosMapping.class, ProducerInfoMapping.class, EndpointInfoMapping.class, RegistrationInfoMapping.class, RegistrationPropertyMapping.class, RegistrationPropertyDescriptionMapping.class);
    }

    private static class MappingToProducerInfoIterator
    implements Iterator<ProducerInfo> {
        private Iterator<ProducerInfoMapping> mappings;

        public MappingToProducerInfoIterator(Iterator<ProducerInfoMapping> infoMappingIterator) {
            this.mappings = infoMappingIterator;
        }

        @Override
        public boolean hasNext() {
            return this.mappings.hasNext();
        }

        @Override
        public ProducerInfo next() {
            return this.mappings.next().toModel(null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported!");
        }
    }
}

