/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.mapping;

import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;

@PrimaryType(name="wsrp:endpointinfo")
public abstract class EndpointInfoMapping {
    public static final String NODE_NAME = "wsrp:endpointinfo";

    @Property(name="wsdlurl")
    public abstract String getWSDLURL();

    public abstract void setWSDLURL(String var1);

    @Property(name="timeout")
    public abstract Integer getWSTimeoutMilliseconds();

    public abstract void setWSTimeoutMilliseconds(Integer var1);

    @Property(name="enablewss")
    @DefaultValue(value={"false"})
    public abstract boolean getWSSEnabled();

    public abstract void setWSSEnabled(boolean var1);

    public void initFrom(EndpointConfigurationInfo info) {
        this.setWSDLURL(info.getWsdlDefinitionURL());
        this.setWSTimeoutMilliseconds(info.getWSOperationTimeOut());
        this.setWSSEnabled(info.getWSSEnabled());
    }

    EndpointConfigurationInfo toEndpointConfigurationInfo(EndpointConfigurationInfo initial) {
        initial.setWsdlDefinitionURL(this.getWSDLURL());
        initial.setWSOperationTimeOut(this.getWSTimeoutMilliseconds().intValue());
        initial.setWSSEnabled(this.getWSSEnabled());
        return initial;
    }
}

