/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.jcr;

import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.ChromatticSession;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.jcr.StoresByPathManager;
import org.gatein.wsrp.jcr.mapping.BaseMapping;

public abstract class BaseChromatticPersister
implements ChromatticPersister {
    private Chromattic chrome;
    public static final String WSRP_WORKSPACE_NAME = "wsrp-system";
    public static final String PORTLET_STATES_WORKSPACE_NAME = "pc-system";
    protected static final String REPOSITORY_NAME = "repository";
    protected String workspaceName;
    private Map<Class, Class<? extends BaseMapping>> modelToMapping;
    private ThreadLocal<ChromatticSession> sessionHolder = new ThreadLocal();

    public BaseChromatticPersister(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public void initializeBuilderFor(List<Class> mappingClasses) throws Exception {
        ChromatticBuilder builder = ChromatticBuilder.create();
        builder.setOptionValue(ChromatticBuilder.INSTRUMENTOR_CLASSNAME, (Object)"org.chromattic.apt.InstrumentorImpl");
        this.setBuilderOptions(builder);
        this.modelToMapping = new HashMap<Class, Class<? extends BaseMapping>>(mappingClasses.size());
        for (Class mappingClass : mappingClasses) {
            Object[] interfaces;
            if (BaseMapping.class.isAssignableFrom(mappingClass) && ParameterValidation.existsAndIsNotEmpty((Object[])(interfaces = mappingClass.getGenericInterfaces()))) {
                Class type = (Class)((ParameterizedType)interfaces[0]).getActualTypeArguments()[0];
                this.modelToMapping.put(type, mappingClass);
            }
            builder.add(mappingClass);
        }
        this.chrome = builder.build();
    }

    protected abstract void setBuilderOptions(ChromatticBuilder var1);

    @Override
    public ChromatticSession getSession() {
        ChromatticSession chromatticSession = this.sessionHolder.get();
        if (chromatticSession == null) {
            ChromatticSession session = this.chrome.openSession();
            this.sessionHolder.set(session);
            return session;
        }
        return chromatticSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(boolean save) {
        ChromatticSession session = this.getOpenedSessionOrFail();
        if (save) {
            BaseChromatticPersister baseChromatticPersister = this;
            synchronized (baseChromatticPersister) {
                session.save();
            }
        }
        session.close();
        this.sessionHolder.set(null);
    }

    private ChromatticSession getOpenedSessionOrFail() {
        ChromatticSession session = this.sessionHolder.get();
        if (session == null) {
            throw new IllegalStateException("Cannot close the session as it hasn't been opened first!");
        }
        return session;
    }

    @Override
    public synchronized void save() {
        this.getOpenedSessionOrFail().save();
    }

    @Override
    public <T> boolean delete(T toDelete, StoresByPathManager<T> manager) {
        Class<?> modelClass = toDelete.getClass();
        Class<? extends BaseMapping> baseMappingClass = this.modelToMapping.get(modelClass);
        if (baseMappingClass == null) {
            throw new IllegalArgumentException("Cannot find a mapping class for " + modelClass.getName());
        }
        ChromatticSession session = this.getSession();
        Object old = session.findByPath(baseMappingClass, manager.getChildPath(toDelete));
        if (old != null) {
            session.remove(old);
            this.closeSession(true);
            return true;
        }
        this.closeSession(false);
        return false;
    }
}

