/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.chromattic.api.ChromatticSession;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.impl.RegistrationPersistenceManagerImpl;
import org.gatein.registration.spi.ConsumerGroupSPI;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.registration.mapping.ConsumerCapabilitiesMapping;
import org.gatein.wsrp.registration.mapping.ConsumerGroupMapping;
import org.gatein.wsrp.registration.mapping.ConsumerMapping;
import org.gatein.wsrp.registration.mapping.ConsumersAndGroupsMapping;
import org.gatein.wsrp.registration.mapping.RegistrationMapping;
import org.gatein.wsrp.registration.mapping.RegistrationPropertiesMapping;

public class JCRRegistrationPersistenceManager
extends RegistrationPersistenceManagerImpl {
    private ChromatticPersister persister;
    private ConsumersAndGroupsMapping mappings;
    public static final List<Class> mappingClasses = new ArrayList<Class>(6);

    public JCRRegistrationPersistenceManager(ChromatticPersister persister) throws Exception {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)persister, (String)"ChromatticPersister");
        this.persister = persister;
        ChromatticSession session = persister.getSession();
        this.mappings = (ConsumersAndGroupsMapping)session.findByPath(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
        if (this.mappings == null) {
            this.mappings = (ConsumersAndGroupsMapping)session.insert(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
        }
        persister.save();
        for (ConsumerGroupMapping cgm : this.mappings.getConsumerGroups()) {
            this.internalAddConsumerGroup(cgm.toConsumerGroup(this));
        }
        for (ConsumerMapping cm : this.mappings.getConsumers()) {
            ConsumerSPI consumer = cm.toConsumer(this);
            this.internalAddConsumer(consumer);
            for (Registration registration : consumer.getRegistrations()) {
                this.internalAddRegistration((RegistrationSPI)registration);
            }
        }
        persister.closeSession(false);
    }

    protected RegistrationSPI internalRemoveRegistration(String registrationId) throws RegistrationException {
        Registration registration = this.getRegistration(registrationId);
        this.remove(registration.getPersistentKey(), RegistrationMapping.class);
        return super.internalRemoveRegistration(registrationId);
    }

    protected RegistrationSPI internalCreateRegistration(ConsumerSPI consumer, Map registrationProperties) throws RegistrationException {
        ChromatticSession session = this.persister.getSession();
        RegistrationSPI registration = null;
        try {
            ConsumerMapping cm = (ConsumerMapping)session.findById(ConsumerMapping.class, consumer.getPersistentKey());
            RegistrationMapping rm = cm.createAndAddRegistrationMappingFrom(null);
            registration = this.newRegistrationSPI(consumer, registrationProperties, rm.getPersistentKey());
            rm.initFrom((Registration)registration);
            this.persister.closeSession(true);
        }
        catch (Exception e) {
            this.persister.closeSession(false);
            throw new RegistrationException((Throwable)e);
        }
        return registration;
    }

    protected ConsumerSPI internalRemoveConsumer(String consumerId) throws RegistrationException {
        this.remove(consumerId, ConsumerMapping.class);
        return super.internalRemoveConsumer(consumerId);
    }

    private void remove(String id, Class clazz) {
        ChromatticSession session = this.persister.getSession();
        session.remove(session.findById(clazz, id));
        this.persister.closeSession(true);
    }

    protected ConsumerSPI internalCreateConsumer(String consumerId, String consumerName) throws RegistrationException {
        ConsumerSPI consumer = super.internalCreateConsumer(consumerId, consumerName);
        ChromatticSession session = this.persister.getSession();
        this.mappings = (ConsumersAndGroupsMapping)session.findByPath(ConsumersAndGroupsMapping.class, "wsrp:consumersandgroups");
        try {
            ConsumerMapping cm = this.mappings.createConsumer(consumerId);
            this.mappings.getConsumers().add(cm);
            cm.initFrom((Consumer)consumer);
            consumer.setPersistentKey(cm.getPersistentKey());
            this.persister.closeSession(true);
        }
        catch (Exception e) {
            this.persister.closeSession(false);
            throw new RegistrationException((Throwable)e);
        }
        return consumer;
    }

    protected ConsumerSPI internalSaveChangesTo(Consumer consumer) throws RegistrationException {
        ConsumerSPI consumerSPI = super.internalSaveChangesTo(consumer);
        ChromatticSession session = this.persister.getSession();
        try {
            ConsumerMapping cm = (ConsumerMapping)session.findById(ConsumerMapping.class, consumer.getPersistentKey());
            cm.initFrom(consumer);
            this.persister.closeSession(true);
        }
        catch (Exception e) {
            this.persister.closeSession(false);
            throw new RegistrationException((Throwable)e);
        }
        return consumerSPI;
    }

    protected RegistrationSPI internalSaveChangesTo(Registration registration) throws RegistrationException {
        RegistrationSPI registrationSPI = super.internalSaveChangesTo(registration);
        ChromatticSession session = this.persister.getSession();
        try {
            RegistrationMapping cm = (RegistrationMapping)session.findById(RegistrationMapping.class, registration.getPersistentKey());
            cm.initFrom(registration);
            this.persister.closeSession(true);
        }
        catch (Exception e) {
            this.persister.closeSession(false);
            throw new RegistrationException((Throwable)e);
        }
        return registrationSPI;
    }

    protected ConsumerGroupSPI internalRemoveConsumerGroup(String name) throws RegistrationException {
        try {
            ConsumerGroup group = this.getConsumerGroup(name);
            this.remove(group.getPersistentKey(), ConsumerGroupMapping.class);
        }
        catch (RegistrationException e) {
            throw new IllegalArgumentException("Couldn't remove ConsumerGroup '" + name + "'", e);
        }
        return super.internalRemoveConsumerGroup(name);
    }

    protected ConsumerGroupSPI internalCreateConsumerGroup(String name) throws RegistrationException {
        ConsumerGroupSPI group = super.internalCreateConsumerGroup(name);
        ChromatticSession session = this.persister.getSession();
        try {
            ConsumerGroupMapping cgm = this.mappings.createConsumerGroup(name);
            this.mappings.getConsumerGroups().add(cgm);
            group.setPersistentKey(cgm.getPersistentKey());
            cgm.initFrom((ConsumerGroup)group);
            this.persister.closeSession(true);
        }
        catch (Exception e) {
            this.persister.closeSession(false);
            throw new RegistrationException((Throwable)e);
        }
        return group;
    }

    static {
        Collections.addAll(mappingClasses, ConsumersAndGroupsMapping.class, ConsumerMapping.class, ConsumerGroupMapping.class, RegistrationMapping.class, ConsumerCapabilitiesMapping.class, RegistrationPropertiesMapping.class);
    }
}

