/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration.mapping;

import java.util.Collection;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.FindById;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.spi.ConsumerGroupSPI;
import org.gatein.wsrp.registration.JCRRegistrationPersistenceManager;
import org.gatein.wsrp.registration.mapping.ConsumerMapping;

@PrimaryType(name="wsrp:consumergroup")
public abstract class ConsumerGroupMapping {
    public static final String NODE_NAME = "wsrp:consumergroup";

    @OneToMany(type=RelationshipType.PATH)
    @MappedBy(value="group")
    public abstract Collection<ConsumerMapping> getConsumers();

    @Property(name="name")
    public abstract String getName();

    public abstract void setName(String var1);

    @Property(name="status")
    public abstract RegistrationStatus getStatus();

    public abstract void setStatus(RegistrationStatus var1);

    @Id
    public abstract String getPersistentKey();

    @FindById
    public abstract ConsumerMapping findConsumerById(String var1);

    public void initFrom(ConsumerGroup group) {
        this.setName(group.getName());
        this.setStatus(group.getStatus());
        try {
            for (Consumer consumer : group.getConsumers()) {
                String id = consumer.getPersistentKey();
                ConsumerMapping cm = this.findConsumerById(id);
                ParameterValidation.throwIllegalArgExceptionIfNull((Object)cm, (String)("ConsumerMapping (no such mapping with id: " + id + ")"));
                this.getConsumers().add(cm);
                cm.initFrom(consumer);
            }
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public ConsumerGroupSPI toConsumerGroup(JCRRegistrationPersistenceManager persistenceManager) throws RegistrationException {
        ConsumerGroupSPI group = persistenceManager.newConsumerGroupSPI(this.getName());
        RegistrationStatus status = this.getStatus();
        if (status == null) {
            status = RegistrationStatus.PENDING;
        }
        group.setStatus(status);
        for (ConsumerMapping cm : this.getConsumers()) {
            Consumer consumer = persistenceManager.getConsumerById(cm.getPersistentKey());
            if (consumer == null) {
                consumer = cm.toConsumer(persistenceManager);
            }
            group.addConsumer(consumer);
        }
        return group;
    }
}

