/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration.mapping;

import java.util.List;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FindById;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.wsrp.registration.JCRRegistrationPersistenceManager;
import org.gatein.wsrp.registration.mapping.ConsumerCapabilitiesMapping;
import org.gatein.wsrp.registration.mapping.ConsumerGroupMapping;
import org.gatein.wsrp.registration.mapping.RegistrationMapping;

@PrimaryType(name="wsrp:consumer")
public abstract class ConsumerMapping {
    public static final String NODE_NAME = "wsrp:consumer";

    @Id
    public abstract String getPersistentKey();

    @Property(name="name")
    public abstract String getName();

    public abstract void setName(String var1);

    @Property(name="id")
    public abstract String getId();

    public abstract void setId(String var1);

    @Property(name="consumeragent")
    public abstract String getConsumerAgent();

    public abstract void setConsumerAgent(String var1);

    @OneToMany
    public abstract List<RegistrationMapping> getRegistrations();

    @Create
    public abstract RegistrationMapping createRegistration(String var1);

    @ManyToOne(type=RelationshipType.PATH)
    @MappedBy(value="group")
    public abstract ConsumerGroupMapping getGroup();

    public abstract void setGroup(ConsumerGroupMapping var1);

    @OneToOne
    @Owner
    @MappedBy(value="capabilities")
    public abstract ConsumerCapabilitiesMapping getCapabilities();

    @FindById
    public abstract ConsumerGroupMapping findGroupById(String var1);

    @FindById
    public abstract RegistrationMapping findRegistrationById(String var1);

    public RegistrationMapping createAndAddRegistrationMappingFrom(Registration registration) {
        RegistrationMapping rm;
        if (registration != null) {
            String key = registration.getPersistentKey();
            if (key != null) {
                rm = this.findRegistrationById(key);
            } else {
                rm = this.createRegistration("" + System.nanoTime());
                this.getRegistrations().add(rm);
            }
            rm.initFrom(registration);
        } else {
            rm = this.createRegistration("" + System.nanoTime());
            this.getRegistrations().add(rm);
        }
        return rm;
    }

    public void initFrom(Consumer consumer) {
        this.setName(consumer.getName());
        this.setId(consumer.getId());
        this.setConsumerAgent(consumer.getConsumerAgent());
        ConsumerGroup group = consumer.getGroup();
        if (group != null) {
            ConsumerGroupMapping cgm = this.findGroupById(group.getPersistentKey());
            this.setGroup(cgm);
        }
        ConsumerCapabilitiesMapping ccm = this.getCapabilities();
        ccm.initFrom(consumer.getCapabilities());
        try {
            for (Registration reg : consumer.getRegistrations()) {
                this.createAndAddRegistrationMappingFrom(reg);
            }
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public ConsumerSPI toConsumer(JCRRegistrationPersistenceManager persistenceManager) throws RegistrationException {
        ConsumerSPI consumer = persistenceManager.newConsumerSPI(this.getId(), this.getName());
        consumer.setConsumerAgent(this.getConsumerAgent());
        consumer.setPersistentKey(this.getPersistentKey());
        consumer.setCapabilities(this.getCapabilities().toConsumerCapabilities());
        ConsumerGroupMapping cgm = this.getGroup();
        if (cgm != null) {
            consumer.setGroup(persistenceManager.getConsumerGroup(cgm.getName()));
        }
        for (RegistrationMapping rm : this.getRegistrations()) {
            consumer.addRegistration(rm.toRegistration(persistenceManager, consumer));
        }
        return consumer;
    }
}

