/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration.mapping;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.common.io.IOTools;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;
import org.gatein.wsrp.registration.JCRRegistrationPersistenceManager;
import org.gatein.wsrp.registration.mapping.PortletContextMapping;
import org.gatein.wsrp.registration.mapping.RegistrationPropertiesMapping;

@PrimaryType(name="wsrp:registration")
public abstract class RegistrationMapping {
    public static final String NODE_NAME = "wsrp:registration";

    @Id
    public abstract String getPersistentKey();

    @Property(name="status")
    public abstract RegistrationStatus getStatus();

    public abstract void setStatus(RegistrationStatus var1);

    @Property(name="registrationhandle")
    public abstract String getRegistrationHandle();

    public abstract void setRegistrationHandle(String var1);

    @OneToMany
    public abstract Collection<PortletContextMapping> getPortletContexts();

    @Create
    public abstract PortletContextMapping createPortletContext(String var1);

    @OneToOne
    @Owner
    @MappedBy(value="properties")
    public abstract RegistrationPropertiesMapping getProperties();

    public abstract void setProperties(RegistrationPropertiesMapping var1);

    @Create
    public abstract RegistrationPropertiesMapping createProperties();

    public void initFrom(Registration registration) {
        this.setStatus(registration.getStatus());
        this.setRegistrationHandle(registration.getRegistrationHandle());
        Collection<PortletContextMapping> contextMappings = this.getPortletContexts();
        contextMappings.clear();
        for (PortletContext portletContext : registration.getKnownPortletContexts()) {
            String id = portletContext.getId();
            PortletContextMapping contextMapping = this.createPortletContext(id);
            contextMappings.add(contextMapping);
            if (portletContext instanceof StatefulPortletContext) {
                StatefulPortletContext context = (StatefulPortletContext)portletContext;
                if (PortletStateType.OPAQUE.equals(context.getType())) {
                    contextMapping.initFrom(id, (byte[])context.getState());
                    continue;
                }
                throw new IllegalArgumentException("Cannot handle PortletContext state: " + context.getState());
            }
            contextMapping.initFrom(id, null);
        }
        Map properties = registration.getProperties();
        if (ParameterValidation.existsAndIsNotEmpty((Map)properties)) {
            RegistrationPropertiesMapping rpm = this.getProperties();
            if (rpm == null) {
                rpm = this.createProperties();
                this.setProperties(rpm);
            }
            rpm.initFrom(properties);
        }
    }

    public RegistrationSPI toRegistration(JCRRegistrationPersistenceManager persistenceManager, ConsumerSPI consumer) throws RegistrationException {
        RegistrationPropertiesMapping rpm = this.getProperties();
        Map<Object, Object> props = Collections.emptyMap();
        if (rpm != null) {
            props = rpm.toPropMap();
        }
        RegistrationSPI reg = persistenceManager.newRegistrationSPI(consumer, props, this.getPersistentKey());
        reg.setStatus(this.getStatus());
        reg.setRegistrationHandle(this.getRegistrationHandle());
        Collection<PortletContextMapping> pcms = this.getPortletContexts();
        for (PortletContextMapping pcm : pcms) {
            PortletContext pc = PortletContext.createPortletContext((String)pcm.getId(), (byte[])IOTools.safeGetBytes((InputStream)pcm.getState()));
            reg.addPortletContext(pc, false);
        }
        return reg;
    }
}

