/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.state.mapping;

import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.pc.portlet.impl.state.producer.PortletStateContextImpl;
import org.gatein.pc.portlet.state.producer.PortletStateContext;
import org.gatein.wsrp.producer.state.mapping.PortletStateMapping;

@PrimaryType(name="pc:statecontext")
public abstract class PortletStateContextMapping {
    public static final String NODE_NAME = "pc:statecontext";

    @Id
    public abstract String getPersistentKey();

    @Name
    public abstract String getPortletId();

    @OneToOne
    @Owner
    @MappedBy(value="state")
    public abstract PortletStateMapping getState();

    public PortletStateContext toPortletStateContext() {
        PortletStateMapping psm = this.getState();
        String portletId = psm.getPortletID();
        if (this.getPortletId().equals(portletId)) {
            PortletStateContextImpl context = new PortletStateContextImpl(this.getPersistentKey(), portletId, psm.getPropertiesAsPropertyMap());
            context.getState().setTerminationTime(psm.getTerminationTime());
            return context;
        }
        throw new IllegalStateException("PortletStateContext's portlet id is '" + this.getPortletId() + "' but PortletState has '" + portletId + "'");
    }
}

