/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.chromattic.api.ChromatticSession;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.registry.AbstractConsumerRegistry;
import org.gatein.wsrp.consumer.registry.ConsumerCache;
import org.gatein.wsrp.consumer.registry.mapping.EndpointInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.ProducerInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.ProducerInfosMapping;
import org.gatein.wsrp.consumer.registry.mapping.RegistrationInfoMapping;
import org.gatein.wsrp.consumer.registry.mapping.RegistrationPropertyMapping;
import org.gatein.wsrp.consumer.registry.xml.XMLConsumerRegistry;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.jcr.StoresByPathManager;
import org.gatein.wsrp.jcr.mapping.mixins.LastModified;
import org.gatein.wsrp.jcr.mapping.mixins.ModifyRegistrationRequired;
import org.gatein.wsrp.jcr.mapping.mixins.WSSEndpointEnabled;
import org.gatein.wsrp.registration.mapping.RegistrationPropertyDescriptionMapping;

public class JCRConsumerRegistry
extends AbstractConsumerRegistry
implements StoresByPathManager<ProducerInfo> {
    private ChromatticPersister persister;
    private boolean loadFromXMLIfNeeded;
    private final String rootNodePath;
    static final String PRODUCER_INFOS_PATH = "wsrp:producerinfos";
    public static final List<Class> mappingClasses = new ArrayList<Class>(6);
    private InputStream configurationIS;

    public JCRConsumerRegistry(ChromatticPersister persister) throws Exception {
        this(persister, true);
    }

    protected JCRConsumerRegistry(ChromatticPersister persister, boolean loadFromXMLIfNeeded) {
        this(persister, loadFromXMLIfNeeded, "/");
    }

    protected JCRConsumerRegistry(ChromatticPersister persister, boolean loadFromXMLIfNeeded, String rootNodePath) {
        this.persister = persister;
        this.loadFromXMLIfNeeded = loadFromXMLIfNeeded;
        this.rootNodePath = rootNodePath.endsWith("/") ? rootNodePath : rootNodePath + "/";
        this.initConsumerCache();
    }

    protected void initConsumerCache() {
        this.setConsumerCache((ConsumerCache)new AbstractConsumerRegistry.InMemoryConsumerCache((ConsumerRegistrySPI)this));
    }

    public void setConfigurationIS(InputStream is) {
        this.configurationIS = is;
    }

    public void save(ProducerInfo info, String messageOnError) {
        try {
            ChromatticSession session = this.persister.getSession();
            long now = System.currentTimeMillis();
            ProducerInfosMapping pims = this.getProducerInfosMapping(session);
            pims.setLastModified(now);
            ProducerInfoMapping pim = pims.createProducerInfo(info.getId());
            String key = session.persist((Object)pims, (Object)pim, info.getId());
            info.setKey(key);
            info.setLastModified(now);
            pim.initFrom(info);
            this.persister.closeSession(true);
        }
        catch (Exception e) {
            this.persister.closeSession(false);
            throw new ConsumerException(messageOnError, (Throwable)e);
        }
    }

    public void delete(ProducerInfo info) {
        if (!this.persister.delete(info, this)) {
            throw new ConsumerException("Couldn't delete ProducerInfo " + info);
        }
    }

    public String update(ProducerInfo producerInfo) {
        String key = producerInfo.getKey();
        if (key == null) {
            throw new IllegalArgumentException("ProducerInfo '" + producerInfo.getId() + "' hasn't been persisted and thus cannot be updated.");
        }
        ChromatticSession session = this.persister.getSession();
        long now = System.currentTimeMillis();
        ProducerInfoMapping pim = (ProducerInfoMapping)session.findById(ProducerInfoMapping.class, key);
        if (pim == null) {
            throw new IllegalArgumentException("Couldn't find ProducerInfoMapping associated with key " + key);
        }
        String oldId = pim.getId();
        String newId = producerInfo.getId();
        producerInfo.setLastModified(now);
        pim.initFrom(producerInfo);
        boolean idUnchanged = oldId.equals(newId);
        ProducerInfosMapping pims = this.getProducerInfosMapping(session);
        pims.setLastModified(now);
        if (!idUnchanged) {
            Map<String, ProducerInfoMapping> nameToProducerInfoMap = pims.getNameToProducerInfoMap();
            nameToProducerInfoMap.put(pim.getId(), pim);
        }
        this.persister.closeSession(true);
        return idUnchanged ? null : oldId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ProducerInfo> getProducerInfosFromStorage() {
        ChromatticSession session = this.persister.getSession();
        try {
            List<ProducerInfoMapping> pims = this.getProducerInfosMapping(session).getProducerInfos();
            ArrayList<ProducerInfo> infos = new ArrayList<ProducerInfo>(pims.size());
            for (ProducerInfoMapping pim : pims) {
                infos.add(pim.toModel(null, (ConsumerRegistrySPI)this));
            }
            Iterator<ProducerInfo> iterator = infos.iterator();
            return iterator;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerInfo loadProducerInfo(String id) {
        try {
            ChromatticSession session = this.persister.getSession();
            ProducerInfoMapping pim = this.getProducerInfoMapping(id, session);
            if (pim != null) {
                ProducerInfo producerInfo = pim.toModel(null, (ConsumerRegistrySPI)this);
                return producerInfo;
            }
            ProducerInfo producerInfo = null;
            return producerInfo;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPersistedLastModifiedForProducerInfoWith(String id) {
        try {
            ChromatticSession session = this.persister.getSession();
            ProducerInfoMapping pim = this.getProducerInfoMapping(id, session);
            if (pim != null) {
                long l = pim.getLastModified();
                return l;
            }
            log.debug("There is no ProducerInfo with id '" + id + "'. Return Long.MIN_VALUE for last modified time.");
            long l = Long.MIN_VALUE;
            return l;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    private ProducerInfoMapping getProducerInfoMapping(String id, ChromatticSession session) {
        return (ProducerInfoMapping)session.findByPath(ProducerInfoMapping.class, JCRConsumerRegistry.getPathFor(id));
    }

    public boolean containsConsumer(String id) {
        ChromatticSession session = this.persister.getSession();
        try {
            boolean bl = session.getJCRSession().itemExists(this.rootNodePath + JCRConsumerRegistry.getPathFor(id));
            return bl;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    public Collection<String> getConfiguredConsumersIds() {
        ChromatticSession session = this.persister.getSession();
        try {
            RowIterator rows = this.getProducerInfoIds(session);
            long size = rows.getSize();
            if (size == 0L) {
                List<String> list = Collections.emptyList();
                return list;
            }
            ArrayList<String> ids = new ArrayList<String>(size != -1L ? (int)size : 7);
            while (rows.hasNext()) {
                Row row = rows.nextRow();
                Value rowValue = row.getValue("producerid");
                ids.add(rowValue.getString());
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    private RowIterator getProducerInfoIds(ChromatticSession session) throws RepositoryException {
        Session jcrSession = session.getJCRSession();
        Query query = jcrSession.getWorkspace().getQueryManager().createQuery("select producerid from wsrp:producerinfo", "sql");
        QueryResult queryResult = query.execute();
        return queryResult.getRows();
    }

    public int getConfiguredConsumerNumber() {
        ChromatticSession session = this.persister.getSession();
        try {
            RowIterator ids = this.getProducerInfoIds(session);
            int n = (int)ids.getSize();
            return n;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    private ProducerInfosMapping getProducerInfosMapping(ChromatticSession session) {
        ProducerInfosMapping producerInfosMapping = (ProducerInfosMapping)session.findByPath(ProducerInfosMapping.class, PRODUCER_INFOS_PATH);
        if (producerInfosMapping == null) {
            producerInfosMapping = (ProducerInfosMapping)session.insert(ProducerInfosMapping.class, PRODUCER_INFOS_PATH);
            if (this.loadFromXMLIfNeeded) {
                XMLConsumerRegistry fromXML = new XMLConsumerRegistry(this.configurationIS);
                fromXML.reloadConsumers();
                List<ProducerInfoMapping> infos = producerInfosMapping.getProducerInfos();
                List xmlConsumers = fromXML.getConfiguredConsumers();
                for (WSRPConsumer consumer : xmlConsumers) {
                    ProducerInfo info = consumer.getProducerInfo();
                    ProducerInfoMapping pim = producerInfosMapping.createProducerInfo(info.getId());
                    infos.add(pim);
                    pim.initFrom(info);
                    info.setKey(pim.getKey());
                    this.consumerCache.putConsumer(info.getId(), consumer);
                }
                producerInfosMapping.setLastModified(System.currentTimeMillis());
                session.save();
            }
        }
        return producerInfosMapping;
    }

    @Override
    public String getChildPath(ProducerInfo needsComputedPath) {
        return JCRConsumerRegistry.getPathFor(needsComputedPath);
    }

    @Override
    public LastModified lastModifiedToUpdateOnDelete(ChromatticSession session) {
        ProducerInfosMapping pims = (ProducerInfosMapping)session.findByPath(ProducerInfosMapping.class, PRODUCER_INFOS_PATH);
        if (pims != null) {
            return pims.getLastModifiedMixin();
        }
        return null;
    }

    private static String getPathFor(ProducerInfo info) {
        return JCRConsumerRegistry.getPathFor(info.getId());
    }

    private static String getPathFor(String producerInfoId) {
        return "wsrp:producerinfos/" + producerInfoId;
    }

    private static ProducerInfoMapping toProducerInfoMapping(ProducerInfo producerInfo, ChromatticSession session) {
        ProducerInfoMapping pim = (ProducerInfoMapping)session.findById(ProducerInfoMapping.class, producerInfo.getKey());
        if (pim == null) {
            pim = (ProducerInfoMapping)session.insert(ProducerInfoMapping.class, JCRConsumerRegistry.getPathFor(producerInfo));
        }
        pim.initFrom(producerInfo);
        return pim;
    }

    ChromatticPersister getPersister() {
        return this.persister;
    }

    static {
        Collections.addAll(mappingClasses, ProducerInfosMapping.class, ProducerInfoMapping.class, EndpointInfoMapping.class, RegistrationInfoMapping.class, RegistrationPropertyMapping.class, RegistrationPropertyDescriptionMapping.class, LastModified.class, ModifyRegistrationRequired.class, WSSEndpointEnabled.class);
    }
}

