/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.mapping;

import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.config.impl.ProducerConfigurationImpl;
import org.gatein.wsrp.producer.config.mapping.RegistrationRequirementsMapping;

@PrimaryType(name="wsrp:producerconfiguration")
public abstract class ProducerConfigurationMapping {
    public static final String NODE_NAME = "wsrp:producerconfiguration";

    @Property(name="strictmode")
    public abstract boolean getUsingStrictMode();

    public abstract void setUsingStrictMode(boolean var1);

    @OneToOne
    @Owner
    @MappedBy(value="registrationrequirements")
    public abstract RegistrationRequirementsMapping getRegistrationRequirements();

    public void initFrom(ProducerConfiguration configuration) {
        this.setUsingStrictMode(configuration.isUsingStrictMode());
        RegistrationRequirementsMapping rrm = this.getRegistrationRequirements();
        rrm.initFrom(configuration.getRegistrationRequirements());
    }

    public ProducerConfiguration toProducerConfiguration() {
        ProducerConfigurationImpl configuration = new ProducerConfigurationImpl();
        configuration.setUsingStrictMode(this.getUsingStrictMode());
        ProducerRegistrationRequirements req = this.getRegistrationRequirements().toProducerRegistrationRequirements();
        configuration.setRegistrationRequirements(req);
        return configuration;
    }
}

