/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.chromattic.api.ChromatticSession;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.api.context.ConsumerStructureProvider;
import org.gatein.wsrp.consumer.migration.ExportInfo;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.migration.mapping.ExportErrorMapping;
import org.gatein.wsrp.consumer.migration.mapping.ExportInfoMapping;
import org.gatein.wsrp.consumer.migration.mapping.ExportInfosMapping;
import org.gatein.wsrp.consumer.migration.mapping.ExportedStateMapping;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.jcr.StoresByPathManager;
import org.gatein.wsrp.jcr.mapping.mixins.LastModified;

public class JCRMigrationService
implements MigrationService,
StoresByPathManager<ExportInfo> {
    private ConsumerStructureProvider structureProvider;
    private ChromatticPersister persister;
    private static final String EXPORT_INFOS_PATH = "wsrp:exportinfos";
    private int exportInfosCount = -1;
    public static final List<Class> mappingClasses = new ArrayList<Class>(4);

    public JCRMigrationService(ChromatticPersister persister) throws Exception {
        this.persister = persister;
    }

    public ConsumerStructureProvider getStructureProvider() {
        return this.structureProvider;
    }

    public void setStructureProvider(ConsumerStructureProvider structureProvider) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)structureProvider, (String)"PortalStructureProvider");
        this.structureProvider = structureProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExportInfo> getAvailableExportInfos() {
        try {
            ChromatticSession session = this.persister.getSession();
            ExportInfosMapping exportInfosMapping = this.getExportInfosMapping(session);
            List<ExportInfoMapping> exportInfoMappings = exportInfosMapping.getExportInfos();
            ArrayList<ExportInfo> exportInfos = new ArrayList<ExportInfo>(exportInfoMappings.size());
            for (ExportInfoMapping eim : exportInfoMappings) {
                exportInfos.add(eim.toModel(null, null));
            }
            this.exportInfosCount = exportInfos.size();
            ArrayList<ExportInfo> arrayList = exportInfos;
            return arrayList;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    private ExportInfosMapping getExportInfosMapping(ChromatticSession session) {
        ExportInfosMapping exportInfosMapping = (ExportInfosMapping)session.findByPath(ExportInfosMapping.class, EXPORT_INFOS_PATH);
        if (exportInfosMapping == null) {
            exportInfosMapping = (ExportInfosMapping)session.insert(ExportInfosMapping.class, EXPORT_INFOS_PATH);
            this.exportInfosCount = 0;
        }
        return exportInfosMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportInfo getExportInfo(long exportTime) {
        try {
            ChromatticSession session = this.persister.getSession();
            ExportInfoMapping eim = (ExportInfoMapping)session.findByPath(ExportInfoMapping.class, this.getPathFor(exportTime));
            if (eim != null) {
                ExportInfo exportInfo = eim.toModel(null, null);
                return exportInfo;
            }
            ExportInfo exportInfo = null;
            return exportInfo;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ExportInfo info) {
        try {
            ChromatticSession session = this.persister.getSession();
            ExportInfoMapping eim = (ExportInfoMapping)session.findByPath(ExportInfoMapping.class, this.getChildPath(info));
            long exportTime = info.getExportTime();
            if (eim != null) {
                throw new IllegalArgumentException("An ExportInfo with export time " + exportTime + " already exists!");
            }
            ExportInfosMapping exportInfosMapping = this.getExportInfosMapping(session);
            String exportTimeAsString = "" + exportTime;
            ExportInfoMapping exportInfo = exportInfosMapping.createExportInfo(exportTimeAsString);
            session.persist((Object)exportInfosMapping, (Object)exportInfo, exportTimeAsString);
            exportInfo.initFrom(info);
            this.persister.save();
            ++this.exportInfosCount;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    public ExportInfo remove(ExportInfo info) {
        if (this.persister.delete(info, this)) {
            --this.exportInfosCount;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailableExportInfosEmpty() {
        if (this.exportInfosCount == -1) {
            try {
                ChromatticSession session = this.persister.getSession();
                ExportInfosMapping mappings = this.getExportInfosMapping(session);
                this.exportInfosCount = mappings.getExportInfos().size();
            }
            finally {
                this.persister.closeSession(false);
            }
        }
        return this.exportInfosCount == 0;
    }

    public String getParentPath() {
        return EXPORT_INFOS_PATH;
    }

    @Override
    public String getChildPath(ExportInfo exportInfo) {
        return this.getPathFor(exportInfo.getExportTime());
    }

    @Override
    public LastModified lastModifiedToUpdateOnDelete(ChromatticSession session) {
        return null;
    }

    private String getPathFor(long exportTime) {
        return this.getParentPath() + "/" + exportTime;
    }

    static {
        Collections.addAll(mappingClasses, ExportInfosMapping.class, ExportInfoMapping.class, ExportedStateMapping.class, ExportErrorMapping.class);
    }
}

