/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.mapping;

import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.jcr.mapping.BaseMapping;
import org.gatein.wsrp.jcr.mapping.mixins.MixinHolder;
import org.gatein.wsrp.jcr.mapping.mixins.WSSEndpointEnabled;

@PrimaryType(name="wsrp:endpointinfo")
public abstract class EndpointInfoMapping
extends MixinHolder<WSSEndpointEnabled>
implements BaseMapping<EndpointConfigurationInfo, ProducerInfo> {
    public static final String NODE_NAME = "wsrp:endpointinfo";

    @Property(name="wsdlurl")
    public abstract String getWSDLURL();

    public abstract void setWSDLURL(String var1);

    @Property(name="timeout")
    public abstract Integer getWSTimeoutMilliseconds();

    public abstract void setWSTimeoutMilliseconds(Integer var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract WSSEndpointEnabled getWSSEndpointEnabledMixin();

    protected abstract void setWSSEndpointEnabledMixin(WSSEndpointEnabled var1);

    @Create
    protected abstract WSSEndpointEnabled createWSSEndpointEnabledMixin();

    public void setWSSEnabled(boolean wssEnabled) {
        ((WSSEndpointEnabled)this.getCreatedMixin()).setWSSEnabled(wssEnabled);
    }

    public boolean isWSSEnabled() {
        return ((WSSEndpointEnabled)this.getCreatedMixin()).getWSSEnabled();
    }

    @Override
    public void initFrom(EndpointConfigurationInfo info) {
        this.setWSDLURL(info.getWsdlDefinitionURL());
        this.setWSTimeoutMilliseconds(info.getWSOperationTimeOut());
        this.setWSSEnabled(info.getWSSEnabled());
    }

    @Override
    public EndpointConfigurationInfo toModel(EndpointConfigurationInfo initial, ProducerInfo registry) {
        initial.setWsdlDefinitionURL(this.getWSDLURL());
        initial.setWSOperationTimeOut(this.getWSTimeoutMilliseconds().intValue());
        initial.setWSSEnabled(this.isWSSEnabled());
        return initial;
    }

    @Override
    public Class<EndpointConfigurationInfo> getModelClass() {
        return EndpointConfigurationInfo.class;
    }

    @Override
    public WSSEndpointEnabled getMixin() {
        return this.getWSSEndpointEnabledMixin();
    }

    @Override
    protected void setMixin(WSSEndpointEnabled mixin) {
        this.setWSSEndpointEnabledMixin(mixin);
    }

    @Override
    protected WSSEndpointEnabled createMixin() {
        return this.createWSSEndpointEnabledMixin();
    }
}

