/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.chromattic.api.ChromatticSession;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.impl.AbstractProducerConfigurationService;
import org.gatein.wsrp.producer.config.impl.xml.SimpleXMLProducerConfigurationService;
import org.gatein.wsrp.producer.config.mapping.ProducerConfigurationMapping;
import org.gatein.wsrp.producer.config.mapping.RegistrationRequirementsMapping;
import org.gatein.wsrp.registration.mapping.RegistrationPropertyDescriptionMapping;

public class JCRProducerConfigurationService
extends AbstractProducerConfigurationService {
    private static String PRODUCER_CONFIGURATION_PATH = "wsrp:producerconfiguration";
    private InputStream defaultConfigurationIS;
    private ChromatticPersister persister;
    public static final List<Class> mappingClasses = new ArrayList<Class>(3);

    public JCRProducerConfigurationService(ChromatticPersister persister) throws Exception {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)persister, (String)"ChromatticPersister");
        this.persister = persister;
    }

    public void setConfigurationIS(InputStream is) {
        this.defaultConfigurationIS = is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfiguration() throws Exception {
        try {
            ChromatticSession session = this.persister.getSession();
            ProducerConfigurationMapping pcm = (ProducerConfigurationMapping)session.findByPath(ProducerConfigurationMapping.class, PRODUCER_CONFIGURATION_PATH);
            if (pcm == null) {
                pcm = (ProducerConfigurationMapping)session.insert(ProducerConfigurationMapping.class, PRODUCER_CONFIGURATION_PATH);
                SimpleXMLProducerConfigurationService service = new SimpleXMLProducerConfigurationService(this.defaultConfigurationIS);
                service.reloadConfiguration();
                this.configuration.set(service.getConfiguration());
                pcm.initFrom((ProducerConfiguration)this.configuration.get());
                this.persister.save();
            } else {
                this.configuration.set(pcm.toModel(null, (ProducerConfigurationService)this));
            }
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration() throws Exception {
        try {
            ChromatticSession session = this.persister.getSession();
            ProducerConfigurationMapping pcm = (ProducerConfigurationMapping)session.findByPath(ProducerConfigurationMapping.class, PRODUCER_CONFIGURATION_PATH);
            if (pcm == null) {
                pcm = (ProducerConfigurationMapping)session.insert(ProducerConfigurationMapping.class, PRODUCER_CONFIGURATION_PATH);
            }
            pcm.initFrom((ProducerConfiguration)this.configuration.get());
            this.persister.save();
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPersistedLastModifiedForConfiguration() {
        try {
            ChromatticSession session = this.persister.getSession();
            ProducerConfigurationMapping pcm = (ProducerConfigurationMapping)session.findByPath(ProducerConfigurationMapping.class, PRODUCER_CONFIGURATION_PATH);
            long l = pcm == null ? 0L : pcm.getLastModified();
            return l;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    public ChromatticPersister getPersister() {
        return this.persister;
    }

    static {
        Collections.addAll(mappingClasses, ProducerConfigurationMapping.class, RegistrationRequirementsMapping.class, RegistrationPropertyDescriptionMapping.class);
    }
}

