/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.endpoints.v1;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.jws.HandlerChain;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.endpoints.WSRPBaseEndpoint;
import org.gatein.wsrp.spec.v1.V1ToV2Converter;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InteractionParams;
import org.oasis.wsrp.v1.V1InvalidCookie;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidSession;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1MarkupContext;
import org.oasis.wsrp.v1.V1MarkupParams;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletStateChangeRequired;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RuntimeContext;
import org.oasis.wsrp.v1.V1SessionContext;
import org.oasis.wsrp.v1.V1UnsupportedLocale;
import org.oasis.wsrp.v1.V1UnsupportedMimeType;
import org.oasis.wsrp.v1.V1UnsupportedMode;
import org.oasis.wsrp.v1.V1UnsupportedWindowState;
import org.oasis.wsrp.v1.V1UpdateResponse;
import org.oasis.wsrp.v1.V1UserContext;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InitCookie;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletStateChangeRequired;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ReleaseSessions;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UserContext;

@WebService(name="WSRPV1MarkupPortType", serviceName="WSRPService", portName="WSRPMarkupService", targetNamespace="urn:oasis:names:tc:wsrp:v1:wsdl", wsdlLocation="/WEB-INF/wsdl/wsrp_services.wsdl", endpointInterface="org.oasis.wsrp.v1.WSRPV1MarkupPortType")
@HandlerChain(file="../producer-handler-chains.xml")
public class MarkupEndpoint
extends WSRPBaseEndpoint
implements WSRPV1MarkupPortType {
    public void performBlockingInteraction(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1MarkupParams markupParams, @WebParam(name="interactionParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1InteractionParams interactionParams, @WebParam(mode=WebParam.Mode.OUT, name="updateResponse", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1UpdateResponse> updateResponse, @WebParam(mode=WebParam.Mode.OUT, name="redirectURL", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> redirectURL, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1MissingParameters, V1UnsupportedLocale, V1InconsistentParameters, V1PortletStateChangeRequired, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        BlockingInteractionResponse interactionResponse;
        this.forceSessionAccess();
        PerformBlockingInteraction performBlockingInteraction = WSRPTypeFactory.createPerformBlockingInteraction((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (PortletContext)V1ToV2Converter.toV2PortletContext((V1PortletContext)portletContext), (RuntimeContext)V1ToV2Converter.toV2RuntimeContext((V1RuntimeContext)runtimeContext, (String)portletContext.getPortletHandle()), (UserContext)V1ToV2Converter.toV2UserContext((V1UserContext)userContext), (MarkupParams)V1ToV2Converter.toV2MarkupParams((V1MarkupParams)markupParams), (InteractionParams)V1ToV2Converter.toV2InteractionParams((V1InteractionParams)interactionParams));
        try {
            interactionResponse = this.producer.performBlockingInteraction(performBlockingInteraction);
        }
        catch (InvalidCookie invalidCookie) {
            throw (V1InvalidCookie)V2ToV1Converter.toV1Exception(V1InvalidCookie.class, (Exception)((Object)invalidCookie));
        }
        catch (InvalidHandle invalidHandle) {
            throw (V1InvalidHandle)V2ToV1Converter.toV1Exception(V1InvalidHandle.class, (Exception)((Object)invalidHandle));
        }
        catch (InvalidSession invalidSession) {
            throw (V1InvalidSession)V2ToV1Converter.toV1Exception(V1InvalidSession.class, (Exception)((Object)invalidSession));
        }
        catch (UnsupportedMode unsupportedMode) {
            throw (V1UnsupportedMode)V2ToV1Converter.toV1Exception(V1UnsupportedMode.class, (Exception)((Object)unsupportedMode));
        }
        catch (UnsupportedMimeType unsupportedMimeType) {
            throw (V1UnsupportedMimeType)V2ToV1Converter.toV1Exception(V1UnsupportedMimeType.class, (Exception)((Object)unsupportedMimeType));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (UnsupportedWindowState unsupportedWindowState) {
            throw (V1UnsupportedWindowState)V2ToV1Converter.toV1Exception(V1UnsupportedWindowState.class, (Exception)((Object)unsupportedWindowState));
        }
        catch (UnsupportedLocale unsupportedLocale) {
            throw (V1UnsupportedLocale)V2ToV1Converter.toV1Exception(V1UnsupportedLocale.class, (Exception)((Object)unsupportedLocale));
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (PortletStateChangeRequired portletStateChangeRequired) {
            throw (V1PortletStateChangeRequired)V2ToV1Converter.toV1Exception(V1PortletStateChangeRequired.class, (Exception)((Object)portletStateChangeRequired));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidUserCategory invalidUserCategory) {
            throw (V1InvalidUserCategory)V2ToV1Converter.toV1Exception(V1InvalidUserCategory.class, (Exception)((Object)invalidUserCategory));
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        updateResponse.value = V2ToV1Converter.toV1UpdateResponse((UpdateResponse)interactionResponse.getUpdateResponse());
        redirectURL.value = interactionResponse.getRedirectURL();
        extensions.value = Lists.transform((List)interactionResponse.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
    }

    public List<V1Extension> releaseSessions(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="sessionIDs", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> sessionIDs) throws V1MissingParameters, V1InvalidRegistration, V1AccessDenied, V1OperationFailed {
        List extensions;
        this.forceSessionAccess();
        ReleaseSessions releaseSessions = WSRPTypeFactory.createReleaseSessions((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), sessionIDs);
        try {
            extensions = this.producer.releaseSessions(releaseSessions);
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
        return Lists.transform((List)extensions, (Function)V2ToV1Converter.EXTENSION);
    }

    public void getMarkup(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1MarkupParams markupParams, @WebParam(mode=WebParam.Mode.OUT, name="markupContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1MarkupContext> markupContext, @WebParam(mode=WebParam.Mode.OUT, name="sessionContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1SessionContext> sessionContext, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1MissingParameters, V1UnsupportedLocale, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        MarkupResponse response;
        this.forceSessionAccess();
        GetMarkup getMarkup = WSRPTypeFactory.createGetMarkup((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (PortletContext)V1ToV2Converter.toV2PortletContext((V1PortletContext)portletContext), (RuntimeContext)V1ToV2Converter.toV2RuntimeContext((V1RuntimeContext)runtimeContext, (String)portletContext.getPortletHandle()), (UserContext)V1ToV2Converter.toV2UserContext((V1UserContext)userContext), (MarkupParams)V1ToV2Converter.toV2MarkupParams((V1MarkupParams)markupParams));
        try {
            response = this.producer.getMarkup(getMarkup);
        }
        catch (UnsupportedWindowState unsupportedWindowState) {
            throw (V1UnsupportedWindowState)V2ToV1Converter.toV1Exception(V1UnsupportedWindowState.class, (Exception)((Object)unsupportedWindowState));
        }
        catch (InvalidCookie invalidCookie) {
            throw (V1InvalidCookie)V2ToV1Converter.toV1Exception(V1InvalidCookie.class, (Exception)((Object)invalidCookie));
        }
        catch (InvalidSession invalidSession) {
            throw (V1InvalidSession)V2ToV1Converter.toV1Exception(V1InvalidSession.class, (Exception)((Object)invalidSession));
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (InvalidHandle invalidHandle) {
            throw (V1InvalidHandle)V2ToV1Converter.toV1Exception(V1InvalidHandle.class, (Exception)((Object)invalidHandle));
        }
        catch (UnsupportedLocale unsupportedLocale) {
            throw (V1UnsupportedLocale)V2ToV1Converter.toV1Exception(V1UnsupportedLocale.class, (Exception)((Object)unsupportedLocale));
        }
        catch (UnsupportedMode unsupportedMode) {
            throw (V1UnsupportedMode)V2ToV1Converter.toV1Exception(V1UnsupportedMode.class, (Exception)((Object)unsupportedMode));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidUserCategory invalidUserCategory) {
            throw (V1InvalidUserCategory)V2ToV1Converter.toV1Exception(V1InvalidUserCategory.class, (Exception)((Object)invalidUserCategory));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (UnsupportedMimeType unsupportedMimeType) {
            throw (V1UnsupportedMimeType)V2ToV1Converter.toV1Exception(V1UnsupportedMimeType.class, (Exception)((Object)unsupportedMimeType));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        markupContext.value = V2ToV1Converter.toV1MarkupContext((MarkupContext)response.getMarkupContext());
        sessionContext.value = V2ToV1Converter.toV1SessionContext((SessionContext)response.getSessionContext());
        extensions.value = Lists.transform((List)response.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
    }

    public List<V1Extension> initCookie(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext) throws V1InvalidRegistration, V1AccessDenied, V1OperationFailed {
        List extensions;
        this.forceSessionAccess();
        InitCookie initCookie = WSRPTypeFactory.createInitCookie((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext));
        try {
            extensions = this.producer.initCookie(initCookie);
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
        return Lists.transform((List)extensions, (Function)V2ToV1Converter.EXTENSION);
    }
}

