/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletContext;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;

public class RegistrationImpl
implements RegistrationSPI {
    private String key;
    private ConsumerSPI consumer;
    private RegistrationStatus status;
    private Map<QName, Object> properties;
    private String registrationHandle;
    private Set<PortletContext> portletContexts;
    private transient RegistrationPersistenceManager manager;

    RegistrationImpl(ConsumerSPI consumer, RegistrationStatus status, Map<QName, Object> properties, RegistrationPersistenceManager manager) {
        this.consumer = consumer;
        this.status = status;
        this.properties = new HashMap<QName, Object>(properties);
        this.portletContexts = new HashSet<PortletContext>();
        this.manager = manager;
    }

    @Override
    public String getPersistentKey() {
        return this.key;
    }

    @Override
    public void setPersistentKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationImpl that = (RegistrationImpl)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public void setRegistrationHandle(String handle) {
        this.registrationHandle = handle;
    }

    @Override
    public String getRegistrationHandle() {
        return this.registrationHandle;
    }

    @Override
    public ConsumerSPI getConsumer() {
        return this.consumer;
    }

    @Override
    public void addPortletContext(PortletContext portletContext) throws RegistrationException {
        this.addPortletContext(portletContext, true);
    }

    @Override
    public void addPortletContext(PortletContext portletContext, boolean needsSaving) throws RegistrationException {
        this.portletContexts.add(portletContext);
        if (needsSaving) {
            this.manager.saveChangesTo(this);
        }
    }

    @Override
    public void removePortletContext(PortletContext portletContext) throws RegistrationException {
        this.removePortletContext(portletContext, true);
    }

    @Override
    public void removePortletContext(PortletContext portletContext, boolean needsSaving) throws RegistrationException {
        this.portletContexts.remove(portletContext);
        this.manager.saveChangesTo(this);
    }

    @Override
    public Map<QName, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void setPropertyValueFor(QName propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)value, (String)"Property value");
        Object oldValue = this.properties.get(propertyName);
        if (!value.equals(oldValue)) {
            this.properties.put(propertyName, value);
        }
    }

    @Override
    public void setPropertyValueFor(String propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.setPropertyValueFor(new QName(propertyName), value);
    }

    @Override
    public Object getPropertyValueFor(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        return this.properties.get(propertyName);
    }

    @Override
    public Object getPropertyValueFor(String propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        return this.getPropertyValueFor(new QName(propertyName));
    }

    @Override
    public void removeProperty(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.properties.remove(propertyName);
    }

    @Override
    public void removeProperty(String propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.removeProperty(new QName(propertyName));
    }

    @Override
    public boolean hasEqualProperties(Registration registration) {
        if (registration == null) {
            return false;
        }
        Map<QName, Object> other = registration.getProperties();
        return this.hasEqualProperties(other);
    }

    @Override
    public boolean hasEqualProperties(Map registrationProperties) {
        if (registrationProperties == null) {
            return false;
        }
        if (this.properties.size() != registrationProperties.size()) {
            return false;
        }
        for (Map.Entry<QName, Object> entry : this.properties.entrySet()) {
            QName name = entry.getKey();
            if (entry.getValue().equals(registrationProperties.get(name))) continue;
            return false;
        }
        return true;
    }

    public void setRegistrationPropertyValueFor(String propertyName, Object value) {
        this.setPropertyValueFor(new QName(propertyName), value);
    }

    @Override
    public RegistrationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(RegistrationStatus status) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)status, (String)"RegistrationStatus");
        this.status = status;
    }

    @Override
    public void updateProperties(Map registrationProperties) {
        this.properties = new HashMap<QName, Object>(registrationProperties);
    }

    @Override
    public boolean knows(PortletContext portletContext) {
        return this.portletContexts.contains(portletContext);
    }

    @Override
    public boolean knows(String portletContextId) {
        return this.knows(PortletContext.createPortletContext((String)portletContextId));
    }

    @Override
    public Set<PortletContext> getKnownPortletContexts() {
        return Collections.unmodifiableSet(this.portletContexts);
    }
}

