/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.policies;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletContext;
import org.gatein.registration.Consumer;
import org.gatein.registration.DuplicateRegistrationException;
import org.gatein.registration.InvalidConsumerDataException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.registration.PropertyDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegistrationPolicy
implements RegistrationPolicy {
    static final String MISSING_VALUE_ERROR_MSG_BEGIN = "Missing value for expected '";
    private RegistrationPropertyValidator validator = DefaultRegistrationPropertyValidator.DEFAULT;
    private static final Logger log = LoggerFactory.getLogger(DefaultRegistrationPolicy.class);
    static final String INVALID_VALUE_ERROR_MSG_BEGIN = "Invalid value for property '";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRegistrationPolicy that = (DefaultRegistrationPolicy)o;
        return this.validator.equals(that.validator);
    }

    public int hashCode() {
        return this.validator.hashCode();
    }

    @Override
    public void validateRegistrationDataFor(Map<QName, Object> registrationProperties, String consumerIdentity, Map<QName, ? extends PropertyDescription> expectations, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
        Consumer consumer;
        ParameterValidation.throwIllegalArgExceptionIfNull(registrationProperties, (String)"Registration properties");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerIdentity, (String)"Consumer identity", null);
        StringBuilder message = new StringBuilder();
        if (expectations != null) {
            Set<QName> expectedNames = expectations.keySet();
            boolean consistentWithExpectations = true;
            HashSet<QName> unexpected = new HashSet<QName>(registrationProperties.keySet());
            unexpected.removeAll(expectedNames);
            if (!unexpected.isEmpty()) {
                consistentWithExpectations = false;
                message.append("Consumer '").append(consumerIdentity).append("' provided values for unexpected registration properties:\n");
                for (QName name : unexpected) {
                    message.append("\t- ").append(name).append("\n");
                }
            }
            for (Map.Entry<QName, ? extends PropertyDescription> entry : expectations.entrySet()) {
                QName name = entry.getKey();
                Object value = registrationProperties.get(name);
                if (value == null || value instanceof String && ((String)value).length() == 0) {
                    message.append(MISSING_VALUE_ERROR_MSG_BEGIN).append(name.getLocalPart()).append("' property.\n");
                    consistentWithExpectations = false;
                    continue;
                }
                try {
                    this.validator.validateValueFor(name, value);
                }
                catch (IllegalArgumentException e) {
                    message.append(INVALID_VALUE_ERROR_MSG_BEGIN).append(name.getLocalPart()).append("' property.\n").append(e.getLocalizedMessage()).append("\n");
                    consistentWithExpectations = false;
                }
            }
            if (!consistentWithExpectations) {
                String messageString = message.toString();
                log.debug(messageString);
                throw new InvalidConsumerDataException(messageString);
            }
        }
        if ((consumer = manager.getConsumerByIdentity(consumerIdentity)) != null && !RegistrationStatus.PENDING.equals(consumer.getStatus())) {
            for (Registration registration : consumer.getRegistrations()) {
                if (!registration.hasEqualProperties(registrationProperties)) continue;
                throw new DuplicateRegistrationException("Consumer named '" + consumer.getName() + "' has already been registered with the same set of registration properties. Registration rejected!", null, registration);
            }
        }
    }

    @Override
    public String createRegistrationHandleFor(String registrationId) {
        return registrationId;
    }

    @Override
    public String getAutomaticGroupNameFor(String consumerName) {
        return null;
    }

    @Override
    public String getConsumerIdFrom(String consumerName, Map<QName, Object> registrationProperties) throws IllegalArgumentException, InvalidConsumerDataException {
        return consumerName;
    }

    @Override
    public void validateConsumerName(String consumerName, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
        if (manager.isConsumerExisting(this.getConsumerIdFrom(consumerName, Collections.<QName, Object>emptyMap()))) {
            throw new DuplicateRegistrationException("A Consumer named '" + consumerName + "' has already been registered.");
        }
    }

    @Override
    public void validateConsumerGroupName(String groupName, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
    }

    @Override
    public boolean allowAccessTo(PortletContext portletContext, Registration registration, String operation) {
        return true;
    }

    @Override
    public boolean isWrapped() {
        return false;
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public Class<? extends RegistrationPolicy> getRealClass() {
        return this.getClass();
    }

    public void setValidator(RegistrationPropertyValidator validator) {
        this.validator = validator;
    }

    public RegistrationPropertyValidator getValidator() {
        return this.validator;
    }
}

