/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl;

import java.util.List;
import java.util.Set;
import org.gatein.registration.RegistrationPolicyChangeListener;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.wsrp.producer.WSRPValidator;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationChangeListener;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;

public abstract class AbstractProducerConfigurationService
implements ProducerConfigurationService {
    protected ProducerConfiguration configuration;

    @Override
    public ProducerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void reloadConfiguration() throws Exception {
        this.reloadConfiguration(false);
    }

    @Override
    public void reloadConfiguration(boolean triggerListeners) throws Exception {
        ProducerRegistrationRequirements registrationRequirements;
        List<ProducerConfigurationChangeListener> listeners = null;
        Set<RegistrationPolicyChangeListener> policyListeners = null;
        Set<RegistrationPropertyChangeListener> propertyListeners = null;
        if (this.configuration != null) {
            listeners = this.configuration.getChangeListeners();
            registrationRequirements = this.configuration.getRegistrationRequirements();
            if (registrationRequirements != null) {
                policyListeners = registrationRequirements.getPolicyChangeListeners();
                propertyListeners = registrationRequirements.getPropertyChangeListeners();
            }
        }
        this.loadConfiguration();
        WSRPValidator.setStrict(this.configuration.isUsingStrictMode());
        if (listeners != null) {
            for (ProducerConfigurationChangeListener producerConfigurationChangeListener : listeners) {
                this.configuration.addChangeListener(producerConfigurationChangeListener);
                if (!triggerListeners) continue;
                producerConfigurationChangeListener.usingStrictModeChangedTo(this.configuration.isUsingStrictMode());
            }
        }
        if ((registrationRequirements = this.configuration.getRegistrationRequirements()) != null) {
            if (propertyListeners != null) {
                for (RegistrationPropertyChangeListener registrationPropertyChangeListener : propertyListeners) {
                    registrationRequirements.addRegistrationPropertyChangeListener(registrationPropertyChangeListener);
                    if (!triggerListeners) continue;
                    registrationPropertyChangeListener.propertiesHaveChanged(registrationRequirements.getRegistrationProperties());
                }
            }
            if (policyListeners != null) {
                for (RegistrationPolicyChangeListener registrationPolicyChangeListener : policyListeners) {
                    registrationRequirements.addRegistrationPolicyChangeListener(registrationPolicyChangeListener);
                    if (!triggerListeners) continue;
                    registrationPolicyChangeListener.policyUpdatedTo(registrationRequirements.getPolicy());
                }
            }
        }
    }

    protected abstract void loadConfiguration() throws Exception;
}

