/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.data;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.gatein.exports.data.ExportData;

public class ExportContext
extends ExportData {
    protected static final String ENCODING = "UTF-8";
    public static final String TYPE = "WSRP_EC";
    public static final double VERSION = 1.0;
    protected long currentTime;
    protected long terminationTime;
    protected long refreshDuration;
    protected final boolean exportByValue;
    protected List<String> portlets;

    public ExportContext() {
        this.exportByValue = true;
    }

    public ExportContext(boolean exportByValue, long currentTime, long terminationTime, long refreshDuration) {
        if (exportByValue) {
            this.currentTime = currentTime;
            this.terminationTime = terminationTime;
            this.refreshDuration = refreshDuration;
        }
        this.exportByValue = exportByValue;
    }

    public ExportContext(String refId, long currentTime, long terminationTime, long refreshDuration) {
        this.currentTime = currentTime;
        this.terminationTime = terminationTime;
        this.refreshDuration = refreshDuration;
        this.exportByValue = false;
    }

    public boolean isExportByValue() {
        return this.exportByValue;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public long getTermintationTime() {
        return this.terminationTime;
    }

    public void setTerminationTime(long terminationTime) {
        this.terminationTime = terminationTime;
    }

    public long getRefreshDuration() {
        return this.refreshDuration;
    }

    public void setRefreshDuration(long refreshDuration) {
        this.refreshDuration = refreshDuration;
    }

    public void addPortlet(String portletName) {
        if (this.portlets == null) {
            this.portlets = new ArrayList<String>();
        }
        this.portlets.add(portletName);
    }

    public List<String> getPortlets() {
        return this.portlets;
    }

    public static ExportContext create(byte[] bytes) {
        ExportContext exportContext = new ExportContext();
        return exportContext;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double getVersion() {
        return 1.0;
    }

    @Override
    protected byte[] internalEncodeAsBytes() throws UnsupportedEncodingException {
        return "EMPTY".getBytes(ENCODING);
    }
}

