/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.exports.ExportManager;
import org.gatein.exports.impl.ExportManagerImpl;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEvent;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationLocal;
import org.gatein.registration.RegistrationManager;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.api.context.ProducerContext;
import org.gatein.wsrp.producer.MarkupInterface;
import org.gatein.wsrp.producer.PortletManagementInterface;
import org.gatein.wsrp.producer.RegistrationInterface;
import org.gatein.wsrp.producer.ServiceDescriptionInterface;
import org.gatein.wsrp.producer.WSRPValidator;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.handlers.MarkupHandler;
import org.gatein.wsrp.producer.handlers.PortletManagementHandler;
import org.gatein.wsrp.producer.handlers.RegistrationHandler;
import org.gatein.wsrp.producer.handlers.ServiceDescriptionHandler;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.v2.WSRP2Producer;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.ClonePortlet;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.CopyPortlets;
import org.oasis.wsrp.v2.CopyPortletsResponse;
import org.oasis.wsrp.v2.DestroyPortlets;
import org.oasis.wsrp.v2.DestroyPortletsResponse;
import org.oasis.wsrp.v2.ExportByValueNotSupported;
import org.oasis.wsrp.v2.ExportNoLongerValid;
import org.oasis.wsrp.v2.ExportPortlets;
import org.oasis.wsrp.v2.ExportPortletsResponse;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetPortletDescription;
import org.oasis.wsrp.v2.GetPortletProperties;
import org.oasis.wsrp.v2.GetPortletPropertyDescription;
import org.oasis.wsrp.v2.GetPortletsLifetime;
import org.oasis.wsrp.v2.GetPortletsLifetimeResponse;
import org.oasis.wsrp.v2.GetRegistrationLifetime;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.HandleEventsResponse;
import org.oasis.wsrp.v2.ImportPortlets;
import org.oasis.wsrp.v2.ImportPortletsResponse;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InitCookie;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistration;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.PortletDescriptionResponse;
import org.oasis.wsrp.v2.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v2.PortletStateChangeRequired;
import org.oasis.wsrp.v2.PropertyList;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.RegistrationState;
import org.oasis.wsrp.v2.ReleaseExport;
import org.oasis.wsrp.v2.ReleaseSessions;
import org.oasis.wsrp.v2.ResourceResponse;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.ServiceDescription;
import org.oasis.wsrp.v2.SetExportLifetime;
import org.oasis.wsrp.v2.SetPortletProperties;
import org.oasis.wsrp.v2.SetPortletsLifetime;
import org.oasis.wsrp.v2.SetPortletsLifetimeResponse;
import org.oasis.wsrp.v2.SetRegistrationLifetime;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRPProducerImpl
implements WSRP2Producer,
ProducerHelper {
    private static final Logger log = LoggerFactory.getLogger(WSRPProducerImpl.class);
    private PortletInvoker invoker;
    private final MarkupHandler markupHandler = new MarkupHandler(this);
    private final ServiceDescriptionHandler serviceDescriptionHandler = new ServiceDescriptionHandler(this);
    private final RegistrationHandler registrationHandler = new RegistrationHandler(this);
    private final PortletManagementHandler portletManagementHandler = new PortletManagementHandler(this);
    private RegistrationManager registrationManager;
    private ProducerConfigurationService configurationService;
    private ExportManager exportManager;
    private ProducerContext producerContext;
    private boolean started = false;
    private Boolean remotableByDefault;

    static WSRPProducerImpl getInstance() {
        return InstanceHolder.producer;
    }

    static boolean isProducerStarted() {
        return InstanceHolder.producer.started;
    }

    private WSRPProducerImpl() {
    }

    public ProducerRegistrationRequirements getProducerRegistrationRequirements() {
        return this.getProducerConfiguration().getRegistrationRequirements();
    }

    @Override
    public ServiceDescription getServiceDescription(GetServiceDescription gs) throws InvalidRegistration, OperationFailed, ResourceSuspended, ModifyRegistrationRequired {
        return this.serviceDescriptionHandler.getServiceDescription(gs);
    }

    @Override
    public MarkupResponse getMarkup(GetMarkup getMarkup) throws UnsupportedWindowState, InvalidCookie, InvalidSession, AccessDenied, InconsistentParameters, InvalidHandle, UnsupportedLocale, UnsupportedMode, OperationFailed, MissingParameters, InvalidUserCategory, InvalidRegistration, UnsupportedMimeType, ResourceSuspended, ModifyRegistrationRequired {
        return this.markupHandler.getMarkup(getMarkup);
    }

    @Override
    public BlockingInteractionResponse performBlockingInteraction(PerformBlockingInteraction performBlockingInteraction) throws InvalidSession, UnsupportedMode, UnsupportedMimeType, OperationFailed, UnsupportedWindowState, UnsupportedLocale, AccessDenied, PortletStateChangeRequired, InvalidRegistration, MissingParameters, InvalidUserCategory, InconsistentParameters, InvalidHandle, InvalidCookie, ResourceSuspended, ModifyRegistrationRequired {
        return this.markupHandler.performBlockingInteraction(performBlockingInteraction);
    }

    @Override
    public List<Extension> releaseSessions(ReleaseSessions releaseSessions) throws InvalidRegistration, OperationFailed, MissingParameters, AccessDenied, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.markupHandler.releaseSessions(releaseSessions);
    }

    @Override
    public List<Extension> initCookie(InitCookie initCookie) throws AccessDenied, OperationFailed, InvalidRegistration, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.markupHandler.initCookie(initCookie);
    }

    @Override
    public HandleEventsResponse handleEvents(HandleEvents handleEvents) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, PortletStateChangeRequired, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        return this.markupHandler.handleEvents(handleEvents);
    }

    @Override
    public ResourceResponse getResource(GetResource getResource) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState, OperationNotSupported {
        return this.markupHandler.getResource(getResource);
    }

    @Override
    public RegistrationContext register(RegistrationData register) throws MissingParameters, OperationFailed, OperationNotSupported {
        return this.registrationHandler.register(register);
    }

    @Override
    public List<Extension> deregister(RegistrationContext deregister) throws OperationFailed, InvalidRegistration, ResourceSuspended, OperationNotSupported {
        return this.registrationHandler.deregister(deregister);
    }

    @Override
    public RegistrationState modifyRegistration(ModifyRegistration modifyRegistration) throws MissingParameters, OperationFailed, InvalidRegistration, ResourceSuspended, OperationNotSupported {
        return this.registrationHandler.modifyRegistration(modifyRegistration);
    }

    @Override
    public Lifetime getRegistrationLifetime(GetRegistrationLifetime getRegistrationLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.registrationHandler.getRegistrationLifetime(getRegistrationLifetime);
    }

    @Override
    public Lifetime setRegistrationLifetime(SetRegistrationLifetime setRegistrationLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.registrationHandler.setRegistrationLifetime(setRegistrationLifetime);
    }

    @Override
    public PortletDescriptionResponse getPortletDescription(GetPortletDescription getPortletDescription) throws AccessDenied, InvalidHandle, InvalidUserCategory, InconsistentParameters, MissingParameters, InvalidRegistration, OperationFailed, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.portletManagementHandler.getPortletDescription(getPortletDescription);
    }

    @Override
    public PortletContext clonePortlet(ClonePortlet clonePortlet) throws InvalidUserCategory, AccessDenied, OperationFailed, InvalidHandle, InvalidRegistration, InconsistentParameters, MissingParameters, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.portletManagementHandler.clonePortlet(clonePortlet);
    }

    @Override
    public DestroyPortletsResponse destroyPortlets(DestroyPortlets destroyPortlets) throws InconsistentParameters, MissingParameters, InvalidRegistration, OperationFailed, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.portletManagementHandler.destroyPortlets(destroyPortlets);
    }

    @Override
    public PortletContext setPortletProperties(SetPortletProperties setPortletProperties) throws OperationFailed, InvalidHandle, MissingParameters, InconsistentParameters, InvalidUserCategory, AccessDenied, InvalidRegistration, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.portletManagementHandler.setPortletProperties(setPortletProperties);
    }

    @Override
    public PropertyList getPortletProperties(GetPortletProperties getPortletProperties) throws InvalidHandle, MissingParameters, InvalidRegistration, AccessDenied, OperationFailed, InconsistentParameters, InvalidUserCategory, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.portletManagementHandler.getPortletProperties(getPortletProperties);
    }

    @Override
    public PortletPropertyDescriptionResponse getPortletPropertyDescription(GetPortletPropertyDescription getPortletPropertyDescription) throws MissingParameters, InconsistentParameters, InvalidUserCategory, InvalidRegistration, AccessDenied, InvalidHandle, OperationFailed, ResourceSuspended, OperationNotSupported, ModifyRegistrationRequired {
        return this.portletManagementHandler.getPortletPropertyDescription(getPortletPropertyDescription);
    }

    @Override
    public GetPortletsLifetimeResponse getPortletsLifetime(GetPortletsLifetime getPortletsLifetime) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.portletManagementHandler.getPortletsLifetime(getPortletsLifetime);
    }

    @Override
    public SetPortletsLifetimeResponse setPortletsLifetime(SetPortletsLifetime setPortletsLifetime) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.portletManagementHandler.setPortletsLifetime(setPortletsLifetime);
    }

    @Override
    public CopyPortletsResponse copyPortlets(CopyPortlets copyPortlets) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.portletManagementHandler.copyPortlets(copyPortlets);
    }

    @Override
    public ExportPortletsResponse exportPortlets(ExportPortlets exportPortlets) throws AccessDenied, ExportByValueNotSupported, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.portletManagementHandler.exportPortlets(exportPortlets);
    }

    @Override
    public ImportPortletsResponse importPortlets(ImportPortlets importPortlets) throws AccessDenied, ExportNoLongerValid, InconsistentParameters, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.portletManagementHandler.importPortlets(importPortlets);
    }

    @Override
    public List<Extension> releaseExport(ReleaseExport releaseExport) {
        return this.portletManagementHandler.releaseExport(releaseExport);
    }

    @Override
    public Lifetime setExportLifetime(SetExportLifetime setExportLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        return this.portletManagementHandler.setExportLifetime(setExportLifetime);
    }

    private ProducerConfiguration getProducerConfiguration() {
        return this.configurationService.getConfiguration();
    }

    @Override
    public RegistrationManager getRegistrationManager() {
        return this.registrationManager;
    }

    @Override
    public void setRegistrationManager(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
    }

    @Override
    public void setConfigurationService(ProducerConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public ProducerConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public void setExportManager(ExportManager exportManger) {
        this.exportManager = exportManger;
    }

    @Override
    public ProducerContext getProducerContext() {
        return this.producerContext;
    }

    @Override
    public void setProducerContext(ProducerContext producerContext) {
        this.producerContext = producerContext;
    }

    @Override
    public ExportManager getExportManager() {
        if (this.exportManager == null) {
            this.exportManager = new ExportManagerImpl();
        }
        return this.exportManager;
    }

    @Override
    public synchronized void start() {
        if (!this.started) {
            ProducerConfiguration configuration = this.configurationService.getConfiguration();
            configuration.addChangeListener(this);
            this.usingStrictModeChangedTo(configuration.isUsingStrictMode());
            ProducerRegistrationRequirements registrationRequirements = this.getProducerRegistrationRequirements();
            registrationRequirements.addRegistrationPolicyChangeListener(this.registrationManager);
            registrationRequirements.addRegistrationPropertyChangeListener(this.registrationManager);
            this.registrationManager.setPolicy(registrationRequirements.getPolicy());
            this.started = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            ProducerRegistrationRequirements registrationRequirements = this.getProducerRegistrationRequirements();
            registrationRequirements.removeRegistrationPropertyChangeListener(this.registrationManager);
            registrationRequirements.removeRegistrationPolicyChangeListener(this.registrationManager);
            this.getProducerConfiguration().removeChangeListener(this);
            this.started = false;
        }
    }

    int getExpirationTime() {
        return this.getProducerConfiguration().getSessionExpirationTime();
    }

    CookieProtocol getRequiresInitCookie() {
        return this.getProducerConfiguration().getRequiresInitCookie();
    }

    @Override
    public PortletInvoker getPortletInvoker() {
        return this.invoker;
    }

    @Override
    public void setPortletInvoker(PortletInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public Portlet getPortletWith(org.gatein.pc.api.PortletContext portletContext, Registration registration) throws InvalidHandle, PortletInvokerException {
        Portlet portlet;
        try {
            RegistrationLocal.setRegistration(registration);
            portlet = this.invoker.getPortlet(portletContext);
        }
        catch (NoSuchPortletException e) {
            throw (InvalidHandle)((Object)WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Couldn't find portlet with handle '" + portletContext.getId() + "'"), (Throwable)e));
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
        if (!this.isRemotable(portlet)) {
            throw (InvalidHandle)((Object)WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Portlet '" + portletContext.getId() + "' is not remotely available."), null));
        }
        return portlet;
    }

    public Set<Portlet> getRemotablePortlets() throws PortletInvokerException {
        log.debug("Retrieving remotable portlets");
        Set allPortlets = this.invoker.getPortlets();
        int portletNumber = allPortlets.size();
        Set<Portlet> remotablePortlets = Collections.emptySet();
        if (portletNumber > 0) {
            remotablePortlets = new HashSet<Portlet>(portletNumber);
            for (Portlet portlet : allPortlets) {
                log.debug("Found portlet: " + portlet.getContext());
                if (!this.isRemotable(portlet)) continue;
                remotablePortlets.add(portlet);
                log.debug("Adding remotable portlet to set: " + portlet.getContext());
            }
        }
        return remotablePortlets;
    }

    @Override
    public PortletDescription getPortletDescription(PortletContext portletContext, List<String> locales, Registration registration) throws InvalidHandle, OperationFailed {
        return this.serviceDescriptionHandler.getPortletDescription(portletContext, locales, registration);
    }

    @Override
    public Registration getRegistrationOrFailIfInvalid(RegistrationContext registrationContext) throws InvalidRegistration, OperationFailed, ModifyRegistrationRequired {
        Registration registration = this.registrationHandler.getRegistrationFrom(registrationContext);
        this.registrationHandler.isRegistrationValid(registration, true);
        return registration;
    }

    @Override
    public void reset() {
        this.serviceDescriptionHandler.reset();
    }

    public Boolean isRemotableByDefault() {
        return this.remotableByDefault;
    }

    public void setRemotableByDefault(Boolean remotableByDefault) {
        this.remotableByDefault = remotableByDefault;
    }

    private boolean isRemotable(Portlet portlet) {
        Map runtimeOptions = portlet.getInfo().getRuntimeOptionsInfo();
        return this.serviceDescriptionHandler.isRemotable(runtimeOptions);
    }

    public List<String> getSupportedLocales() {
        if (this.producerContext != null) {
            return WSRPUtils.convertLocalesToRFC3066LanguageTags((List)this.producerContext.getSupportedLocales());
        }
        return WSRPConstants.getDefaultLocales();
    }

    @Override
    public void usingStrictModeChangedTo(boolean strictMode) {
        WSRPValidator.setStrict(strictMode);
    }

    MarkupInterface getMarkupInterface() {
        return this.markupHandler;
    }

    ServiceDescriptionInterface getServiceDescriptionInterface() {
        return this.serviceDescriptionHandler;
    }

    RegistrationInterface getRegistrationInterface() {
        return this.registrationHandler;
    }

    PortletManagementInterface getPortletManagementInterface() {
        return this.portletManagementHandler;
    }

    public void onEvent(ManagedObjectRegistryEvent event) {
        this.serviceDescriptionHandler.onEvent(event);
    }

    private static final class InstanceHolder {
        public static final WSRPProducerImpl producer = new WSRPProducerImpl();

        private InstanceHolder() {
        }
    }
}

