/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import org.gatein.common.net.URLTools;
import org.gatein.wsrp.producer.config.impl.xml.ProducerConfigurationProvider;
import org.gatein.wsrp.producer.config.impl.xml.SimpleXMLProducerConfigurationService;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.XercesXsMarshaller;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemXMLProducerConfigurationService
extends SimpleXMLProducerConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(FileSystemXMLProducerConfigurationService.class);
    private String configLocation;
    private File config;
    private static DefaultSchemaResolver RESOLVER = new DefaultSchemaResolver();
    private static final String PRODUCER_NAMESPACE = "http://www.gatein.org/xml/ns/gatein_wsrp_producer_1_0";
    private static final String PRODUCER_XSD = "gatein_wsrp_producer_1_0.xsd";

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void start() throws Exception {
        File dataDir = new File(System.getProperty("java.io.tmpdir"));
        File portalDir = new File(dataDir, "portal");
        if (!portalDir.exists()) {
            if (!portalDir.mkdir()) {
                throw new RuntimeException("Couldn't create 'portal' directory in " + dataDir.getAbsolutePath());
            }
        } else if (!portalDir.isDirectory()) {
            throw new RuntimeException("Was expecting a directory named 'portal' in " + dataDir.getAbsolutePath() + ", not a simple file! Cannot continue.");
        }
        this.config = new File(portalDir, "wsrp-producer-config.xml");
        this.reloadConfiguration();
    }

    @Override
    public void loadConfiguration() throws Exception {
        block2: {
            URL configURL = this.getConfigLocationURL();
            try {
                this.loadConfigurationAt(configURL);
            }
            catch (Exception e) {
                if (!this.config.exists()) break block2;
                log.debug("Configuration saved at " + this.config.getCanonicalPath() + " is not loading properly. Falling back to default configuration.");
                this.config.delete();
                this.loadConfigurationAt(this.getConfigLocationURL());
            }
        }
    }

    private void loadConfigurationAt(URL configURL) throws Exception {
        log.debug("About to parse producer configuration " + configURL);
        this.inputStream = configURL.openStream();
        super.loadConfiguration();
    }

    private URL getConfigLocationURL() throws Exception {
        if (!this.config.exists()) {
            if (this.configLocation == null) {
                throw new Exception("The config location is null");
            }
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(this.configLocation);
            URL configURL = null;
            while (resources.hasMoreElements()) {
                configURL = resources.nextElement();
            }
            if (configURL == null) {
                throw new Exception("The config " + this.configLocation + " does not exist");
            }
            if (!URLTools.exists((URL)configURL)) {
                throw new Exception("The config " + configURL + " does not exist");
            }
            return configURL;
        }
        return this.config.toURI().toURL();
    }

    @Override
    public void saveConfiguration() throws Exception {
        StringWriter xmlOutput = new StringWriter();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("xsd/gatein_wsrp_producer_1_0.xsd");
        InputStreamReader xsReader = new InputStreamReader(is);
        XercesXsMarshaller marshaller = new XercesXsMarshaller();
        marshaller.setSchemaResolver((SchemaBindingResolver)RESOLVER);
        marshaller.addRootElement(PRODUCER_NAMESPACE, "", "producer-configuration");
        marshaller.declareNamespace("wpc", PRODUCER_NAMESPACE);
        marshaller.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        marshaller.addAttribute("xsi", "schemaLocation", "string", "http://www.gatein.org/xml/ns/gatein_wsrp_producer_1_0 http://www.jboss.org/portal/xsd/gatein_wsrp_producer_1_0.xsd");
        ProducerConfigurationProvider provider = new ProducerConfigurationProvider();
        marshaller.setProperty("org.jboss.xml.binding.marshalling.indent", "true");
        marshaller.marshal((Reader)xsReader, (ObjectModelProvider)provider, (Object)this.configuration, (Writer)xmlOutput);
        ((Reader)xsReader).close();
        this.config.createNewFile();
        BufferedWriter configFile = new BufferedWriter(new FileWriter(this.config));
        configFile.write(xmlOutput.toString());
        ((Writer)configFile).flush();
        ((Writer)configFile).close();
    }

    static {
        RESOLVER.setCacheResolvedSchemas(true);
        RESOLVER.addSchemaLocation("http://www.w3.org/XML/1998/namespace", "xsd/xml.xsd");
        RESOLVER.addSchemaLocation(PRODUCER_NAMESPACE, "xsd/gatein_wsrp_producer_1_0.xsd");
    }
}

