/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import org.gatein.common.net.URLTools;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.RequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.WSRPPortletInvocationContext;
import org.gatein.wsrp.servlet.ServletAccess;
import org.oasis.wsrp.v2.MimeResponse;

abstract class MimeResponseProcessor<LocalMimeResponse extends MimeResponse, Response>
extends RequestProcessor<Response> {
    private static final String EMPTY = "";

    protected MimeResponseProcessor(ProducerHelper producer) {
        super(producer);
    }

    @Override
    PortletInvocation initInvocation(WSRPPortletInvocationContext context) {
        return this.internalInitInvocation(context);
    }

    protected String processFragmentString(String renderString) {
        if (!ParameterValidation.isNullOrEmpty((String)renderString)) {
            return URLTools.replaceURLsBy((String)renderString, (URLTools.URLReplacementGenerator)new WSRPUtils.AbsoluteURLReplacementGenerator(ServletAccess.getRequest()));
        }
        return renderString;
    }

    @Override
    protected Response internalProcessResponse(PortletInvocationResponse response) {
        ContentResponse content = (ContentResponse)response;
        String itemString = null;
        byte[] itemBinary = null;
        String contentType = content.getContentType();
        Boolean requiresRewriting = Boolean.FALSE;
        switch (content.getType()) {
            case 1: {
                itemString = this.processFragmentString(content.getChars());
                requiresRewriting = Boolean.TRUE;
                break;
            }
            case 2: {
                itemBinary = content.getBytes();
                break;
            }
            case 0: {
                itemString = EMPTY;
                contentType = this.markupRequest.getMediaType();
            }
        }
        MimeResponse mimeResponse = WSRPTypeFactory.createMimeResponse((String)contentType, (String)itemString, (byte[])itemBinary, this.getReifiedClass());
        mimeResponse.setLocale(this.markupRequest.getLocale());
        Boolean useCachedItem = false;
        mimeResponse.setRequiresRewriting(requiresRewriting);
        mimeResponse.setUseCachedItem(useCachedItem);
        String ccppProfileWarning = null;
        mimeResponse.setCcppProfileWarning(ccppProfileWarning);
        int expires = content.getCacheControl().getExpirationSecs();
        if (expires != 0) {
            if (expires < 0) {
                expires = -1;
            }
            mimeResponse.setCacheControl(WSRPTypeFactory.createCacheControl((int)expires, (String)"wsrp:perUser"));
        }
        this.additionallyProcessIfNeeded(mimeResponse, response);
        return this.createResponse(mimeResponse);
    }

    protected abstract Response createResponse(LocalMimeResponse var1);

    protected abstract Class<LocalMimeResponse> getReifiedClass();

    protected void additionallyProcessIfNeeded(LocalMimeResponse mimeResponse, PortletInvocationResponse response) {
    }

    protected abstract PortletInvocation internalInitInvocation(WSRPPortletInvocationContext var1);
}

