/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.invoker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationDestructionListener;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationLocal;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.spi.RegistrationSPI;
import org.gatein.wsrp.producer.handlers.processors.WSRPInstanceContext;

public class RegistrationCheckingPortletInvoker
extends PortletInvokerInterceptor
implements RegistrationDestructionListener {
    private RegistrationManager registrationManager;
    private static final Logger log = LoggerFactory.getLogger(RegistrationCheckingPortletInvoker.class);

    public void setRegistrationManager(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
        registrationManager.addRegistrationDestructionListener(this);
    }

    private RegistrationPolicy getPolicy() {
        return this.registrationManager.getPolicy();
    }

    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        Registration registration = RegistrationLocal.getRegistration();
        if (registration != null) {
            if (registration.knows(portletContext) || PortletStatus.OFFERED == super.getStatus(portletContext)) {
                return super.getPortlet(portletContext);
            }
            String id = portletContext.getId();
            throw new NoSuchPortletException("Registration '" + registration.getRegistrationHandle() + "' does not know the '" + id + "' portlet", id);
        }
        return super.getPortlet(portletContext);
    }

    public Set<Portlet> getPortlets() throws PortletInvokerException {
        HashSet<Portlet> portlets = new HashSet<Portlet>(super.getPortlets());
        Registration registration = RegistrationLocal.getRegistration();
        if (registration != null) {
            Set<PortletContext> contexts = registration.getKnownPortletContexts();
            for (PortletContext context : contexts) {
                portlets.add(super.getPortlet(context));
            }
        }
        return portlets;
    }

    private RegistrationSPI getRegistrationAsSPI() throws PortletInvokerException {
        Registration registration = RegistrationLocal.getRegistration();
        if (registration == null) {
            return null;
        }
        if (registration instanceof RegistrationSPI) {
            return (RegistrationSPI)registration;
        }
        throw new PortletInvokerException("Cannot deal with non-RegistrationSPI Registrations.");
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContext portletContext = invocation.getTarget();
        RegistrationSPI registration = this.getRegistrationAsSPI();
        if (registration != null) {
            this.checkOperationIsAllowed(portletContext, registration, "invoke");
            PortletInvocationResponse response = super.invoke(invocation);
            InstanceContext instanceContext = invocation.getInstanceContext();
            if (instanceContext instanceof WSRPInstanceContext) {
                WSRPInstanceContext wsrpIC = (WSRPInstanceContext)instanceContext;
                PortletContext responseContext = wsrpIC.getPortletContext();
                if (wsrpIC.wasModified() && !responseContext.getId().equals(portletContext.getId())) {
                    try {
                        registration.addPortletContext(responseContext);
                    }
                    catch (RegistrationException e) {
                        throw new PortletInvokerException("Couldn't add portlet context '" + responseContext + "' to registration '" + registration.getRegistrationHandle() + "'", (Throwable)e);
                    }
                }
            }
            return response;
        }
        return super.invoke(invocation);
    }

    private void checkOperationIsAllowed(PortletContext portletContext, Registration registration, String operation) throws NoSuchPortletException {
        if (!this.getPolicy().allowAccessTo(portletContext, registration, operation)) {
            String id = portletContext.getId();
            throw new NoSuchPortletException("The PortletContext '" + id + "' does not exist or the application is lacking permission to access it for operation '" + operation + "'", id);
        }
    }

    public PortletContext createClone(PortletStateType stateType, PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        RegistrationSPI registration = this.getRegistrationAsSPI();
        if (registration != null) {
            this.checkOperationIsAllowed(portletContext, registration, "createClone");
            PortletContext clonedPortletContext = super.createClone(stateType, portletContext);
            try {
                registration.addPortletContext(clonedPortletContext);
            }
            catch (RegistrationException e) {
                throw new PortletInvokerException("Couldn't add portlet context '" + clonedPortletContext + "' to registration '" + registration.getRegistrationHandle() + "'", (Throwable)e);
            }
            return clonedPortletContext;
        }
        return super.createClone(stateType, portletContext);
    }

    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        RegistrationSPI registration = this.getRegistrationAsSPI();
        if (registration != null) {
            for (PortletContext portletContext : portletContexts) {
                this.checkOperationIsAllowed(portletContext, registration, "destroyClones");
            }
        }
        List cloneFailures = super.destroyClones(portletContexts);
        boolean noFailures = cloneFailures.isEmpty();
        if (registration != null) {
            for (PortletContext portletContext : portletContexts) {
                if (!noFailures && cloneFailures.contains(new DestroyCloneFailure(portletContext.getId()))) continue;
                try {
                    registration.removePortletContext(portletContext);
                }
                catch (RegistrationException e) {
                    throw new PortletInvokerException("Couldn't remove portlet context '" + portletContext + "' to registration '" + registration.getRegistrationHandle() + "'", (Throwable)e);
                }
            }
        }
        return cloneFailures;
    }

    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        this.checkOperationIsAllowed(portletContext, RegistrationLocal.getRegistration(), "getProperties");
        return super.getProperties(portletContext);
    }

    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        this.checkOperationIsAllowed(portletContext, RegistrationLocal.getRegistration(), "getProperties");
        return super.getProperties(portletContext, keys);
    }

    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        RegistrationSPI registration = this.getRegistrationAsSPI();
        if (registration != null) {
            this.checkOperationIsAllowed(portletContext, registration, "setProperties");
            PortletContext updatedPortletContext = super.setProperties(portletContext, changes);
            if (!portletContext.getId().equals(updatedPortletContext.getId())) {
                try {
                    registration.addPortletContext(updatedPortletContext);
                }
                catch (RegistrationException e) {
                    throw new PortletInvokerException("Couldn't add portlet context '" + updatedPortletContext + "' to registration '" + registration.getRegistrationHandle() + "'", (Throwable)e);
                }
            }
            return updatedPortletContext;
        }
        return super.setProperties(portletContext, changes);
    }

    public PortletContext importPortlet(PortletStateType stateType, PortletContext originalPortletContext) throws PortletInvokerException, IllegalArgumentException {
        RegistrationSPI registration = this.getRegistrationAsSPI();
        if (registration != null) {
            this.checkOperationIsAllowed(originalPortletContext, registration, "importPortlet");
            PortletContext newPortletContext = super.importPortlet(stateType, originalPortletContext);
            if (!newPortletContext.getId().equals(originalPortletContext.getId())) {
                try {
                    registration.addPortletContext(newPortletContext);
                }
                catch (RegistrationException e) {
                    throw new PortletInvokerException("Couldn't add portlet context '" + newPortletContext + "' to registration '" + registration.getRegistrationHandle() + "'", (Throwable)e);
                }
            }
            return newPortletContext;
        }
        return super.importPortlet(stateType, originalPortletContext);
    }

    public PortletContext exportPortlet(PortletStateType stateType, PortletContext portletContext) throws PortletInvokerException, IllegalArgumentException {
        this.checkOperationIsAllowed(portletContext, RegistrationLocal.getRegistration(), "exportPortlet");
        return super.exportPortlet(stateType, portletContext);
    }

    @Override
    public RegistrationDestructionListener.Vote destructionScheduledFor(Registration registration) {
        if (registration != null) {
            ArrayList<PortletContext> portletContexts = new ArrayList<PortletContext>(registration.getKnownPortletContexts());
            List failures = Collections.emptyList();
            try {
                failures = super.destroyClones(portletContexts);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Couldn't destroy clones", (Throwable)e);
                }
                return RegistrationDestructionListener.Vote.negativeVote("Couldn't destroy clones: " + failures);
            }
        }
        return RegistrationDestructionListener.SUCCESS;
    }
}

