/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.endpoints.v1;

import com.google.common.base.Function;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.cxf.feature.Features;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.endpoints.WSRPBaseEndpoint;
import org.gatein.wsrp.spec.v1.V1ToV2Converter;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1DestroyFailed;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1Property;
import org.oasis.wsrp.v1.V1PropertyList;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1ResetProperty;
import org.oasis.wsrp.v1.V1ResourceList;
import org.oasis.wsrp.v1.V1UserContext;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.ClonePortlet;
import org.oasis.wsrp.v2.DestroyPortlets;
import org.oasis.wsrp.v2.DestroyPortletsResponse;
import org.oasis.wsrp.v2.GetPortletDescription;
import org.oasis.wsrp.v2.GetPortletProperties;
import org.oasis.wsrp.v2.GetPortletPropertyDescription;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.PortletDescriptionResponse;
import org.oasis.wsrp.v2.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v2.PropertyList;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.SetPortletProperties;
import org.oasis.wsrp.v2.UserContext;

@WebService(name="WSRPV1PortletManagementPortType", serviceName="WSRPService", portName="WSRPPortletManagementService", targetNamespace="urn:oasis:names:tc:wsrp:v1:wsdl", wsdlLocation="/WEB-INF/wsdl/wsrp_services.wsdl", endpointInterface="org.oasis.wsrp.v1.WSRPV1PortletManagementPortType")
@Features(features={"org.gatein.wsrp.cxf.WSRPEndpointFeature"})
public class PortletManagementEndpoint
extends WSRPBaseEndpoint
implements WSRPV1PortletManagementPortType {
    public void getPortletPropertyDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="modelDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ModelDescription> modelDescription, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        try {
            GetPortletPropertyDescription getPortletPropertyDescription = WSRPTypeFactory.createGetPortletPropertyDescription((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (PortletContext)V1ToV2Converter.toV2PortletContext((V1PortletContext)portletContext), (UserContext)V1ToV2Converter.toV2UserContext((V1UserContext)userContext), desiredLocales);
            PortletPropertyDescriptionResponse descriptionResponse = this.producer.getPortletPropertyDescription(getPortletPropertyDescription);
            modelDescription.value = V2ToV1Converter.toV1ModelDescription((ModelDescription)descriptionResponse.getModelDescription());
            resourceList.value = V2ToV1Converter.toV1ResourceList((ResourceList)descriptionResponse.getResourceList());
            extensions.value = WSRPUtils.transform((List)descriptionResponse.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (InvalidHandle invalidHandle) {
            throw (V1InvalidHandle)V2ToV1Converter.toV1Exception(V1InvalidHandle.class, (Exception)((Object)invalidHandle));
        }
        catch (InvalidUserCategory invalidUserCategory) {
            throw (V1InvalidUserCategory)V2ToV1Converter.toV1Exception(V1InvalidUserCategory.class, (Exception)((Object)invalidUserCategory));
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }

    public void setPortletProperties(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="propertyList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PropertyList propertyList, @WebParam(mode=WebParam.Mode.OUT, name="portletHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> portletHandle, @WebParam(mode=WebParam.Mode.OUT, name="portletState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> portletState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        try {
            SetPortletProperties setPortletProperties = WSRPTypeFactory.createSetPortletProperties((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (PortletContext)V1ToV2Converter.toV2PortletContext((V1PortletContext)portletContext), (PropertyList)V1ToV2Converter.toV2PropertyList((V1PropertyList)propertyList));
            setPortletProperties.setUserContext(V1ToV2Converter.toV2UserContext((V1UserContext)userContext));
            PortletContext response = this.producer.setPortletProperties(setPortletProperties);
            portletHandle.value = response.getPortletHandle();
            portletState.value = response.getPortletState();
            extensions.value = WSRPUtils.transform((List)response.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (InvalidHandle invalidHandle) {
            throw (V1InvalidHandle)V2ToV1Converter.toV1Exception(V1InvalidHandle.class, (Exception)((Object)invalidHandle));
        }
        catch (InvalidUserCategory invalidUserCategory) {
            throw (V1InvalidUserCategory)V2ToV1Converter.toV1Exception(V1InvalidUserCategory.class, (Exception)((Object)invalidUserCategory));
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }

    public void clonePortlet(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(mode=WebParam.Mode.OUT, name="portletHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> portletHandle, @WebParam(mode=WebParam.Mode.OUT, name="portletState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> portletState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        try {
            ClonePortlet clonePortlet = WSRPTypeFactory.createClonePortlet((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (PortletContext)V1ToV2Converter.toV2PortletContext((V1PortletContext)portletContext), (UserContext)V1ToV2Converter.toV2UserContext((V1UserContext)userContext));
            PortletContext response = this.producer.clonePortlet(clonePortlet);
            portletHandle.value = response.getPortletHandle();
            portletState.value = response.getPortletState();
            extensions.value = WSRPUtils.transform((List)response.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (InvalidHandle invalidHandle) {
            throw (V1InvalidHandle)V2ToV1Converter.toV1Exception(V1InvalidHandle.class, (Exception)((Object)invalidHandle));
        }
        catch (InvalidUserCategory invalidUserCategory) {
            throw (V1InvalidUserCategory)V2ToV1Converter.toV1Exception(V1InvalidUserCategory.class, (Exception)((Object)invalidUserCategory));
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }

    public void getPortletDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="portletDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1PortletDescription> portletDescription, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        try {
            GetPortletDescription getPortletDescription = WSRPTypeFactory.createGetPortletDescription((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (PortletContext)V1ToV2Converter.toV2PortletContext((V1PortletContext)portletContext), (UserContext)V1ToV2Converter.toV2UserContext((V1UserContext)userContext));
            if (ParameterValidation.existsAndIsNotEmpty(desiredLocales)) {
                getPortletDescription.getDesiredLocales().addAll(desiredLocales);
            }
            PortletDescriptionResponse description = this.producer.getPortletDescription(getPortletDescription);
            portletDescription.value = V2ToV1Converter.toV1PortletDescription((PortletDescription)description.getPortletDescription());
            resourceList.value = V2ToV1Converter.toV1ResourceList((ResourceList)description.getResourceList());
            extensions.value = WSRPUtils.transform((List)description.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (InvalidHandle invalidHandle) {
            throw (V1InvalidHandle)V2ToV1Converter.toV1Exception(V1InvalidHandle.class, (Exception)((Object)invalidHandle));
        }
        catch (InvalidUserCategory invalidUserCategory) {
            throw (V1InvalidUserCategory)V2ToV1Converter.toV1Exception(V1InvalidUserCategory.class, (Exception)((Object)invalidUserCategory));
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }

    public void getPortletProperties(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="names", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> names, @WebParam(mode=WebParam.Mode.OUT, name="properties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Property>> properties, @WebParam(mode=WebParam.Mode.OUT, name="resetProperties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ResetProperty>> resetProperties, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        try {
            GetPortletProperties getPortletProperties = WSRPTypeFactory.createGetPortletProperties((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), (PortletContext)V1ToV2Converter.toV2PortletContext((V1PortletContext)portletContext), (UserContext)V1ToV2Converter.toV2UserContext((V1UserContext)userContext), names);
            PropertyList result = this.producer.getPortletProperties(getPortletProperties);
            properties.value = WSRPUtils.transform((List)result.getProperties(), (Function)V2ToV1Converter.PROPERTY);
            resetProperties.value = WSRPUtils.transform((List)result.getResetProperties(), (Function)V2ToV1Converter.RESETPROPERTY);
            extensions.value = WSRPUtils.transform((List)result.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
        }
        catch (AccessDenied accessDenied) {
            throw (V1AccessDenied)V2ToV1Converter.toV1Exception(V1AccessDenied.class, (Exception)((Object)accessDenied));
        }
        catch (InvalidHandle invalidHandle) {
            throw (V1InvalidHandle)V2ToV1Converter.toV1Exception(V1InvalidHandle.class, (Exception)((Object)invalidHandle));
        }
        catch (InvalidUserCategory invalidUserCategory) {
            throw (V1InvalidUserCategory)V2ToV1Converter.toV1Exception(V1InvalidUserCategory.class, (Exception)((Object)invalidUserCategory));
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }

    public void destroyPortlets(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletHandles", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> portletHandles, @WebParam(mode=WebParam.Mode.OUT, name="destroyFailed", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1DestroyFailed>> destroyFailed, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidRegistration, V1OperationFailed {
        try {
            DestroyPortlets destroyPortlets = WSRPTypeFactory.createDestroyPortlets((RegistrationContext)V1ToV2Converter.toV2RegistrationContext((V1RegistrationContext)registrationContext), portletHandles);
            DestroyPortletsResponse destroyPortletsResponse = this.producer.destroyPortlets(destroyPortlets);
            destroyFailed.value = V2ToV1Converter.toV1DestroyFailed((List)destroyPortletsResponse.getFailedPortlets());
            extensions.value = WSRPUtils.transform((List)destroyPortletsResponse.getExtensions(), (Function)V2ToV1Converter.EXTENSION);
        }
        catch (InconsistentParameters inconsistentParameters) {
            throw (V1InconsistentParameters)V2ToV1Converter.toV1Exception(V1InconsistentParameters.class, (Exception)((Object)inconsistentParameters));
        }
        catch (MissingParameters missingParameters) {
            throw (V1MissingParameters)V2ToV1Converter.toV1Exception(V1MissingParameters.class, (Exception)((Object)missingParameters));
        }
        catch (InvalidRegistration invalidRegistration) {
            throw (V1InvalidRegistration)V2ToV1Converter.toV1Exception(V1InvalidRegistration.class, (Exception)((Object)invalidRegistration));
        }
        catch (OperationFailed operationFailed) {
            throw (V1OperationFailed)V2ToV1Converter.toV1Exception(V1OperationFailed.class, (Exception)((Object)operationFailed));
        }
        catch (ModifyRegistrationRequired modifyRegistrationRequired) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Need to call modifyRegistration", (Throwable)modifyRegistrationRequired);
        }
        catch (ResourceSuspended resourceSuspended) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Resource suspended", (Throwable)resourceSuspended);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.createWSException(V1OperationFailed.class, (String)"Not supported", (Throwable)operationNotSupported);
        }
    }
}

