
/*
 * JBoss, a division of Red Hat
 * Copyright 2010, Red Hat Middleware, LLC, and individual
 * contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.oasis.wsrp.v1;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.0
 * 
 */
@WebService(name = "WSRP_v1_ServiceDescription_PortType", targetNamespace = "urn:oasis:names:tc:wsrp:v1:intf")
public interface WSRPV1ServiceDescriptionPortType {


    /**
     * 
     * @param requiresInitCookie
     * @param customModeDescriptions
     * @param offeredPortlets
     * @param userCategoryDescriptions
     * @param customUserProfileItemDescriptions
     * @param extensions
     * @param customWindowStateDescriptions
     * @param registrationPropertyDescription
     * @param requiresRegistration
     * @param resourceList
     * @param registrationContext
     * @param locales
     * @param desiredLocales
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:getServiceDescription")
    @RequestWrapper(localName = "getServiceDescription", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1GetServiceDescription")
    @ResponseWrapper(localName = "getServiceDescriptionResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1ServiceDescription")
    public void getServiceDescription(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "desiredLocales", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        List<String> desiredLocales,
        @WebParam(name = "requiresRegistration", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<Boolean> requiresRegistration,
        @WebParam(name = "offeredPortlets", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1PortletDescription>> offeredPortlets,
        @WebParam(name = "userCategoryDescriptions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1ItemDescription>> userCategoryDescriptions,
        @WebParam(name = "customUserProfileItemDescriptions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1ItemDescription>> customUserProfileItemDescriptions,
        @WebParam(name = "customWindowStateDescriptions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1ItemDescription>> customWindowStateDescriptions,
        @WebParam(name = "customModeDescriptions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1ItemDescription>> customModeDescriptions,
        @WebParam(name = "requiresInitCookie", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1CookieProtocol> requiresInitCookie,
        @WebParam(name = "registrationPropertyDescription", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1ModelDescription> registrationPropertyDescription,
        @WebParam(name = "locales", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<String>> locales,
        @WebParam(name = "resourceList", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1ResourceList> resourceList,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1InvalidRegistration, V1OperationFailed
    ;

}
