/*
 * Decompiled with CFR 0.152.
 */
package org.wsrp.wss.jboss5.handlers;

import java.io.File;
import java.net.MalformedURLException;
import javax.xml.ws.handler.MessageContext;
import org.jboss.ws.extensions.security.jaxws.WSSecurityHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wsrp.wss.jboss5.handlers.AbstractWSSecurityCredentialHandler;

public abstract class AbstractJBWSSecurityHandlerWrapper
extends WSSecurityHandler {
    protected static final Logger log = LoggerFactory.getLogger(AbstractWSSecurityCredentialHandler.class);
    public static final String GATEIN_CONF_DIR = "gatein.conf.dir";

    protected boolean handleInbound(MessageContext msgContext) {
        return this.handleInboundSecurity(msgContext);
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        return this.handleOutboundSecurity(msgContext);
    }

    protected String getConfigResourceName() {
        File configFile;
        String configFileName = System.getProperty(this.getConfigPropertyName());
        if (configFileName == null) {
            String gateInConfDirectory = System.getProperty(GATEIN_CONF_DIR);
            configFile = new File(gateInConfDirectory, this.getDefaultConfigFileName());
        } else {
            configFile = new File(configFileName);
        }
        if (configFile.exists()) {
            try {
                return configFile.toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                log.warn("Couldn't retrieve GateIn's WS Security " + this.getHandlerType() + " configuration file : " + configFileName, (Throwable)e);
            }
        } else {
            log.debug("No " + this.getDefaultConfigFileName() + " file found in the " + GATEIN_CONF_DIR + " directory. Using default empty WS Security configuration file instead.");
        }
        return this.getInternalConfigFileName();
    }

    protected abstract String getInternalConfigFileName();

    protected abstract String getDefaultConfigFileName();

    protected abstract String getConfigPropertyName();

    protected abstract String getHandlerType();
}

