/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.io.Serializable;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;

abstract class AbstractPositionSequence<P extends Position>
implements PositionSequence<P>,
CoordinateSequence,
Serializable {
    private static final long serialVersionUID = 6884205871950410216L;
    private final PositionFactory<P> factory;

    public AbstractPositionSequence(PositionFactory<P> factory) {
        this.factory = factory;
    }

    private static Coordinate[] toCoordinateArray(AbstractPositionSequence cseq) {
        Coordinate[] coordinates = new Coordinate[cseq.size()];
        for (int i = 0; i < cseq.size(); ++i) {
            coordinates[i] = cseq.getCoordinate(i);
        }
        return coordinates;
    }

    @Override
    public Class<P> getPositionClass() {
        return this.factory.forClass();
    }

    @Override
    public PositionFactory<P> getPositionFactory() {
        return this.factory;
    }

    @Override
    public P getPositionN(int index) {
        double[] co = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, co);
        return this.factory.mkPosition(co);
    }

    public int getDimension() {
        return this.getCoordinateDimension();
    }

    @Override
    public int getCoordinateDimension() {
        return this.factory.getCoordinateDimension();
    }

    @Override
    public abstract PositionSequence<P> clone();

    public Coordinate getCoordinate(int i) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(i, c);
        if (this.getCoordinateDimension() == 2) {
            return this.toCoordinateXY(c);
        }
        if (this.factory.hasMComponent() && this.factory.hasZComponent()) {
            return this.toCoordinateXYZM(c);
        }
        if (this.factory.hasZComponent()) {
            return this.toCoordinateXYZ(c);
        }
        return this.toCoordinateXYM(c);
    }

    private CoordinateXY toCoordinateXY(double[] c) {
        CoordinateXY co = new CoordinateXY();
        co.setX(c[0]);
        co.setY(c[1]);
        return co;
    }

    private CoordinateXYM toCoordinateXYM(double[] c) {
        CoordinateXYM co = new CoordinateXYM();
        co.setX(c[0]);
        co.setY(c[1]);
        co.setM(c[2]);
        return co;
    }

    private Coordinate toCoordinateXYZ(double[] c) {
        Coordinate co = new Coordinate();
        co.setX(c[0]);
        co.setY(c[1]);
        co.setZ(c[2]);
        return co;
    }

    private CoordinateXYZM toCoordinateXYZM(double[] c) {
        CoordinateXYZM co = new CoordinateXYZM();
        co.setX(c[0]);
        co.setY(c[1]);
        co.setZ(c[2]);
        co.setM(c[3]);
        return co;
    }

    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinate(i);
    }

    public void getCoordinate(int index, Coordinate coord) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, c);
        coord.x = c[0];
        coord.y = c[1];
    }

    public double getX(int index) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, c);
        return c[0];
    }

    public double getY(int index) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, c);
        return c[1];
    }

    public double getOrdinate(int i, int ordinateIndex) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(i, c);
        boolean idx = false;
        switch (ordinateIndex) {
            case 0: {
                return c[0];
            }
            case 1: {
                return c[1];
            }
            case 2: {
                return this.factory.hasZComponent() ? c[2] : Double.NaN;
            }
            case 3: {
                return this.factory.hasMComponent() ? c[this.factory.getMComponentIndex()] : Double.NaN;
            }
        }
        throw new IllegalArgumentException("Ordinate index " + ordinateIndex + " is not supported.");
    }

    public abstract void setOrdinate(int var1, int var2, double var3);

    public Coordinate[] toCoordinateArray() {
        return AbstractPositionSequence.toCoordinateArray(this);
    }

    public Envelope expandEnvelope(Envelope envelope) {
        EnvelopeExpander expander = new EnvelopeExpander(envelope);
        this.accept(expander);
        return expander.result();
    }

    @Override
    public abstract void accept(PositionVisitor<P> var1);

    private static class EnvelopeExpander<P extends Position>
    implements PositionVisitor<P> {
        private final Envelope env;
        final double[] buffer = new double[2];

        EnvelopeExpander(Envelope env) {
            this.env = env;
        }

        @Override
        public void visit(P position) {
            double[] ar = ((Position)position).toArray(this.buffer);
            this.env.expandToInclude(ar[0], ar[1]);
        }

        public Envelope result() {
            return this.env;
        }
    }
}

