/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.glassfish.build.utils.MavenHelper;

@Mojo(name="generate-pom")
public final class GeneratePomMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "generate.pom.";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="generate.pom.outputDirectory", defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(property="generate.pom.pomFile", defaultValue="${project.file}")
    private File pomFile;
    @Parameter(property="generate.pom.groupId", defaultValue="${project.groupId}", required=true)
    private String groupId;
    @Parameter(property="generate.pom.artifactId", defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(property="generate.pom.version", defaultValue="${project.version}")
    private String version;
    @Parameter(property="generate.pom.parent")
    private Parent parent;
    @Parameter(property="generate.pom.description")
    private String description;
    @Parameter(property="generate.pom.name")
    private String name;
    @Parameter(property="generate.pom.scm", defaultValue="${project.scm}")
    private Scm scm;
    @Parameter(property="generate.pom.issueManagement", defaultValue="${project.issueManagement}")
    private IssueManagement issueManagement;
    @Parameter(property="generate.pom.mailingLists", defaultValue="${project.mailingLists}")
    private List<MailingList> mailingLists;
    @Parameter(property="generate.pom.developers", defaultValue="${project.developers}")
    private List<Developer> devevelopers;
    @Parameter(property="generate.pom.licenses", defaultValue="${project.licenses}")
    private List<License> licenses;
    @Parameter(property="generate.pom.organization", defaultValue="${project.organization}")
    private Organization organization;
    @Parameter(property="generate.pom.excludeDependencies")
    private String excludeDependencies;
    @Parameter(property="generate.pom.excludeDependencyScope", defaultValue="system,test")
    private String excludeDependencyScopes;
    @Parameter(property="generate.pom.dependencies", defaultValue="${project.dependencies}")
    private List<Dependency> dependencies;
    @Parameter(property="generate.pom.skip", defaultValue="false")
    private Boolean skip;
    @Parameter(property="generate.pom.attach", defaultValue="false")
    private Boolean attach;

    private static boolean validateString(String str) {
        return str != null && !str.isEmpty();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"skipping...");
            return;
        }
        Model model = MavenHelper.readModel(this.pomFile);
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setDevelopers(this.devevelopers);
        if (this.parent != null && GeneratePomMojo.validateString(this.parent.getGroupId()) && GeneratePomMojo.validateString(this.parent.getArtifactId()) && GeneratePomMojo.validateString(this.parent.getVersion())) {
            model.setParent(this.parent);
        } else {
            model.setParent(null);
        }
        model.setName(this.name);
        model.setDescription(this.description);
        model.setScm(this.scm);
        model.setIssueManagement(this.issueManagement);
        model.setMailingLists(this.mailingLists);
        model.setLicenses(this.licenses);
        model.setOrganization(this.organization);
        model.setBuild(new Build());
        List<String> artifactIdExclusions = MavenHelper.getCommaSeparatedList(this.excludeDependencies);
        List<String> scopeExclusions = MavenHelper.getCommaSeparatedList(this.excludeDependencyScopes);
        for (Object o : this.dependencies.toArray()) {
            Dependency d = (Dependency)o;
            if (!artifactIdExclusions.contains(d.getArtifactId()) && !scopeExclusions.contains(d.getScope())) continue;
            this.dependencies.remove(d);
        }
        model.setDependencies(this.dependencies);
        File newPomFile = new File(this.outputDirectory, "pom.xml");
        newPomFile.getParentFile().mkdirs();
        FileWriter fw = null;
        try {
            String line;
            fw = new FileWriter(newPomFile);
            BufferedReader br = new BufferedReader(new FileReader(this.pomFile));
            while ((line = br.readLine()) != null && !line.startsWith("<project")) {
                fw.write(line);
                fw.write(10);
            }
            String pom = MavenHelper.modelAsString(model);
            int ind = pom.indexOf(10);
            fw.write(pom.substring(ind));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.attach.booleanValue()) {
            this.project.setFile(newPomFile);
        }
    }
}

