/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.types.ZipFileSet;
import org.glassfish.build.utils.MavenHelper;

@Mojo(name="zip", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public final class ZipMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "gfzip.outputDirectory";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="gfzip.outputDirectoryoutputDirectory", defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(property="gfzip.outputDirectoryfinalName", defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(property="gfzip.outputDirectoryduplicate", defaultValue="add")
    private String duplicate;
    @Parameter(property="gfzip.outputDirectoryfilesets")
    private ZipFileSet[] filesets;
    @Parameter(property="gfzip.outputDirectorydir", defaultValue="${project.build.directory}")
    private File dir;
    @Parameter(property="gfzip.outputDirectoryincludes")
    private String includes;
    @Parameter(property="gfzip.outputDirectoryexcludes")
    private String excludes;
    @Parameter(property="gfzip.outputDirectoryextension", defaultValue="zip")
    private String extension;
    @Parameter(property="gfzip.outputDirectoryattach", defaultValue="true")
    private Boolean attach;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<ZipFileSet> fsets;
        this.project.addCompileSourceRoot(null);
        if (this.filesets != null && this.filesets.length > 0) {
            fsets = Arrays.asList(this.filesets);
        } else {
            fsets = new ArrayList<ZipFileSet>();
            fsets.add(MavenHelper.createZipFileSet(this.dir, this.includes, this.excludes));
        }
        File target = MavenHelper.createZip(this.project.getProperties(), this.getLog(), this.duplicate, fsets, new File(this.outputDirectory, this.finalName + '.' + this.extension));
        if (this.attach.booleanValue()) {
            this.project.getArtifact().setFile(target);
            this.project.getArtifact().setArtifactHandler((ArtifactHandler)new DistributionArtifactHandler(this.extension, this.project.getPackaging()));
        }
    }

    private static final class DistributionArtifactHandler
    implements ArtifactHandler {
        private final String extension;
        private final String packaging;

        private DistributionArtifactHandler(String ext, String pkg) {
            this.extension = ext;
            this.packaging = pkg;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getDirectory() {
            return null;
        }

        public String getClassifier() {
            return null;
        }

        public String getPackaging() {
            return this.packaging;
        }

        public boolean isIncludesDependencies() {
            return false;
        }

        public String getLanguage() {
            return "java";
        }

        public boolean isAddedToClasspath() {
            return false;
        }
    }
}

