/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.javaee.services.ResourceManager;
import org.glassfish.javaee.services.ResourcesBinder;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scoped(value=Singleton.class)
@Service(name="ApplicationScopedResourcesManager")
public class ApplicationScopedResourcesManager
implements PostStartup,
PostConstruct,
PreDestroy,
ConfigListener {
    private static final Logger _logger = LogDomains.getLogger(ResourceManager.class, (String)"LogStrings");
    @Inject
    private ResourcesBinder resourcesBinder;
    @Inject
    private Habitat deployerHabitat;
    @Inject
    private Habitat habitat;
    @Inject
    private Habitat connectorRuntimeHabitat;
    @Inject
    private Applications applications;
    ConnectorRuntime runtime;

    public void postConstruct() {
        List apps = this.applications.getApplications();
        if (apps != null) {
            for (Application app : apps) {
                List modules;
                Resources resources = app.getResources();
                if (resources != null) {
                    this.deployResources(resources.getResources());
                }
                if ((modules = app.getModule()) == null) continue;
                for (Module module : modules) {
                    Resources moduleResources = module.getResources();
                    if (moduleResources == null) continue;
                    this.deployResources(moduleResources.getResources());
                }
            }
        }
    }

    public Resources getResources(String applicationName) {
        Application app = this.applications.getApplication(applicationName);
        if (app != null) {
            return app.getResources();
        }
        return null;
    }

    public void deployResources(String applicationName) {
        Application app = this.applications.getApplication(applicationName);
        if (app != null) {
            List modules;
            Resources appScopedResources = app.getResources();
            if (appScopedResources != null) {
                this.deployResources(appScopedResources.getResources());
            }
            if ((modules = app.getModule()) != null) {
                for (Module module : modules) {
                    Resources moduleScopedResources = module.getResources();
                    if (moduleScopedResources == null) continue;
                    this.deployResources(moduleScopedResources.getResources());
                }
            }
        }
    }

    public void deployResources(Collection<Resource> resources) {
        if (resources != null) {
            String applicationName = null;
            String moduleName = null;
            for (Resource resource : resources) {
                ConfigBeanProxy parentObject = resource.getParent().getParent();
                if (parentObject instanceof Application) {
                    applicationName = ((Application)parentObject).getName();
                } else if (parentObject instanceof Module) {
                    moduleName = ((Module)parentObject).getName();
                    applicationName = ((Application)((Module)parentObject).getParent()).getName();
                }
                if (resource instanceof BindableResource) {
                    BindableResource bindableResource = (BindableResource)resource;
                    ResourceInfo resourceInfo = new ResourceInfo(bindableResource.getJndiName(), applicationName, moduleName);
                    this.resourcesBinder.deployResource(resourceInfo, resource);
                    continue;
                }
                if (resource instanceof ResourcePool) continue;
                try {
                    this.getResourceDeployer(resource).deployResource((Object)resource, applicationName, moduleName);
                }
                catch (Exception e) {
                    Object[] params = new Object[]{ConnectorsUtil.getGenericResourceInfo((Resource)resource), e};
                    _logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
                }
            }
            this.addListenerToResources(resources);
        }
    }

    public boolean isConnectorRuntimeInitialized() {
        Collection inhabitants = this.connectorRuntimeHabitat.getInhabitants(ConnectorRuntime.class);
        Iterator i$ = inhabitants.iterator();
        if (i$.hasNext()) {
            Inhabitant inhabitant = (Inhabitant)i$.next();
            return inhabitant.isInstantiated();
        }
        return true;
    }

    public void preDestroy() {
        if (this.isConnectorRuntimeInitialized()) {
            List apps = this.applications.getApplications();
            if (apps != null) {
                for (Application app : apps) {
                    List modules;
                    Resources resources = app.getResources();
                    if (resources != null) {
                        this.undeploySystemResources(resources);
                    }
                    if ((modules = app.getModule()) == null) continue;
                    for (Module module : modules) {
                        Resources moduleScopedResources = module.getResources();
                        if (moduleScopedResources == null) continue;
                        this.undeploySystemResources(moduleScopedResources);
                    }
                }
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ConnectorRuntime not initialized, hence skipping resource-adapters shutdown, resources, pools cleanup");
        }
    }

    public void undeployResources(String applicationName) {
        Application app = this.applications.getApplication(applicationName);
        if (app != null) {
            Resources appScopedResources;
            List modules = app.getModule();
            if (modules != null) {
                for (Module module : modules) {
                    Resources moduleScopedResources = module.getResources();
                    if (moduleScopedResources == null) continue;
                    this.undeployResources(moduleScopedResources);
                }
            }
            if ((appScopedResources = app.getResources()) != null) {
                this.undeployResources(appScopedResources);
            }
        }
    }

    private void undeploySystemResources(Resources resources) {
        Collection systemResources = ConnectorsUtil.getAllSystemRAResourcesAndPools((Resources)resources);
        for (Resource resource : systemResources) {
            this.undeployResource(resource);
        }
    }

    public void undeployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            this.undeployResource(resource);
        }
    }

    public void undeployResources(Resources resources) {
        for (Resource resource : resources.getResources()) {
            if (resource instanceof ResourcePool || resource instanceof ResourceAdapterConfig) continue;
            this.undeployResource(resource);
        }
        Collection pools = resources.getResources(ResourcePool.class);
        for (ResourcePool pool : pools) {
            this.undeployResource((Resource)pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployResource(Resource resource) {
        try {
            this.getResourceDeployer(resource).undeployResource((Object)resource);
        }
        catch (Exception e) {
            Object[] params = new Object[]{ConnectorsUtil.getGenericResourceInfo((Resource)resource), e};
            _logger.log(Level.WARNING, "resources.resource-manager.undeploy-resource-failed", params);
        }
        finally {
            this.removeListenerFromResource(resource);
        }
    }

    private void addListenerToResources(Collection<Resource> resources) {
        if (resources != null) {
            for (Resource resource : resources) {
                this.addListenerToResource(resource);
            }
        }
    }

    private void addListenerToResource(Resource instance) {
        ObservableBean bean = null;
        if (_logger.isLoggable(Level.FINEST)) {
            this.debug("adding listener : " + instance);
        }
        bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)instance);
        bean.addListener((ConfigListener)this);
    }

    private void removeListenerFromResources(Resources resources) {
        if (resources != null) {
            for (Resource configuredResource : resources.getResources()) {
                this.removeListenerFromResource(configuredResource);
            }
        }
    }

    private void removeListenerFromResource(Resource instance) {
        ObservableBean bean = null;
        this.debug("removing listener : " + instance);
        bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)instance);
        bean.removeListener((ConfigListener)this);
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = this.deployerHabitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = (ConnectorRuntime)this.habitat.getComponent(ConnectorRuntime.class, null);
        }
        return this.runtime;
    }

    private void debug(String message) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("[ASR] [ApplicationScopedResourcesManager] " + message);
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new ConfigChangeHandler(events), (Logger)_logger);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigChangeHandler
    implements Changed {
        PropertyChangeEvent[] events;

        private ConfigChangeHandler(PropertyChangeEvent[] events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            try {
                NotProcessed np;
                ClassLoader ccl = ApplicationScopedResourcesManager.this.getConnectorRuntime().getConnectorClassLoader();
                Thread.currentThread().setContextClassLoader(ccl);
                switch (type) {
                    case ADD: {
                        np = this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        np = this.handleRemoveEvent(changedInstance);
                        break;
                    }
                    default: {
                        np = new NotProcessed("Unrecognized type of change: " + type);
                    }
                }
                NotProcessed notProcessed = np;
                return notProcessed;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
            NotProcessed np = null;
            if (instance instanceof Application) {
                Application app;
                List modules;
                Resources resources = ((Application)instance).getResources();
                if (resources != null) {
                    ApplicationScopedResourcesManager.this.addListenerToResources(resources.getResources());
                }
                if ((modules = (app = (Application)instance).getModule()) != null) {
                    for (Module module : modules) {
                        if (module.getResources() == null || module.getResources().getResources() == null) continue;
                        ApplicationScopedResourcesManager.this.addListenerToResources(module.getResources().getResources());
                    }
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
            NotProcessed np = null;
            if (instance instanceof Application) {
                ApplicationScopedResourcesManager.this.removeListenerFromResources(((Application)instance).getResources());
                Application app = (Application)instance;
                List modules = app.getModule();
                if (modules != null) {
                    for (Module module : modules) {
                        if (module.getResources() == null || module.getResources().getResources() == null) continue;
                        ApplicationScopedResourcesManager.this.removeListenerFromResources(module.getResources());
                    }
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            NotProcessed np = null;
            ApplicationScopedResourcesManager.this.debug("handling change event");
            try {
                if (ConnectorsUtil.isValidEventType(instance)) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        ApplicationScopedResourcesManager.this.debug("redeploying resource : " + instance);
                    }
                    ApplicationScopedResourcesManager.this.getResourceDeployer(instance).redeployResource(instance);
                } else if (ConnectorsUtil.isValidEventType((Object)instance.getParent())) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        ApplicationScopedResourcesManager.this.debug("redeploying resource due to property change : " + instance.getParent());
                    }
                    ApplicationScopedResourcesManager.this.getResourceDeployer(instance.getParent()).redeployResource((Object)instance.getParent());
                }
            }
            catch (Exception ex) {
                String msg = ApplicationScopedResourcesManager.class.getName() + " : " + "Error while handling change Event";
                _logger.severe(msg);
                np = new NotProcessed(msg);
            }
            return np;
        }
    }
}

