/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

public class CatchInstrumentor
extends MethodInstrumentor {
    private Map<Label, String> handlers = new HashMap<Label, String>();

    public CatchInstrumentor(MethodVisitor mv, int access, String name, String desc) {
        super(mv, access, name, desc);
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        String catchType = this.handlers.get(label);
        if (catchType != null) {
            this.onCatch(catchType);
        }
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type2) {
        if (type2 != null) {
            this.handlers.put(handler, type2);
        }
        super.visitTryCatchBlock(start, end, handler, type2);
    }

    protected void onCatch(String type2) {
        this.println("catching " + type2);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.CatchInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new CatchInstrumentor(mv, access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

